/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.oauth;

import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.*;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthModule;

import java.lang.annotation.Annotation;

import javax.lang.model.type.TypeKind;

public abstract class AbstractOAuthClientAnnotationVerifier extends AbstractBaseAnnotationVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    protected abstract void verify(OAuthModule oAuthModule,NotificationGatherer gatherer) throws AnnotationVerificationException ;

    @Override
    public void verify(Module module,NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        if (module instanceof OAuthModule && ((OAuthModule) module).getUserIdentifierMethod() != null) {
            if (!((OAuthModule) module).getUserIdentifierMethod().getReturnType().toString().equals("java.lang.String")) {
                gatherer.error(module, Message.DEVKIT_148);
            }
            if (!((OAuthModule) module).getUserIdentifierMethod().isPublic()) {
                gatherer.error(module, Message.DEVKIT_149);
            }
            if (((OAuthModule) module).getUserIdentifierMethod().isStatic()) {
                gatherer.error(module, Message.DEVKIT_150);
            }
            if (!((OAuthModule) module).getUserIdentifierMethod().getParameters().isEmpty()) {
                gatherer.error(module, Message.DEVKIT_151);
            }
        }

        verify((OAuthModule)module,gatherer);
    }

    protected void verifyPostAuthorizationMethod(OAuthModule module) throws AnnotationVerificationException {
        if (module.getPostAuthorizationMethod() != null &&
                module.getPostAuthorizationMethod().isPrivate()) {
            getGatherer().error(module, Message.DEVKIT_152);
        }

        if (module.getPostAuthorizationMethod() != null &&
                module.getPostAuthorizationMethod().getParameters().size() > 0) {
            getGatherer().error(module, Message.DEVKIT_153);
        }

            if (module.getPostAuthorizationMethod() != null &&
                module.getPostAuthorizationMethod().isStatic()) {
            getGatherer().error(module, Message.DEVKIT_154);
        }

        if (module.getPostAuthorizationMethod() != null &&
                module.getPostAuthorizationMethod().getReturnType().getKind() != TypeKind.VOID) {
            getGatherer().error(module, Message.DEVKIT_155);
        }
    }

    protected boolean classHasMethodWithParameterAnnotated(Module module, Class<? extends Annotation> annotation) {
        for (Method<Type> method : module.getMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (parameter.hasAnnotation(annotation)) {
                    return true;
                }
            }
        }
        return false;
    }
}