/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.oauth;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.*;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;

public class OAuth2ClientAnnotationVerifier extends AbstractOAuthClientAnnotationVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return super.shouldVerify(module) &&
                module instanceof OAuthModule && ((OAuthModule) module).getOAuthVersion() == OAuthVersion.V2;
    }


    public void verify(OAuthModule module,NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (module.getKind() == ModuleKind.GENERIC) {
            gatherer.error(module, Message.DEVKIT_172);
        }
        if (module.getConsumerKeyField() == null) {
            gatherer.error(module, Message.DEVKIT_173);
        }else{
            if (!module.getConsumerKeyField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_174);
            }
            if (!module.getConsumerKeyField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_175);
            }
        }
        if (module.getConsumerSecretField() == null) {
            gatherer.error(module, Message.DEVKIT_176);
        }else{
            if (!module.getConsumerSecretField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_177);
            }
            if (!module.getConsumerSecretField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_178);
            }
        }
        if (classHasMethodWithParameterAnnotated(module, OAuthAccessToken.class)) {
            gatherer.error(module, Message.DEVKIT_179);
        }
        if (classHasMethodWithParameterAnnotated(module, OAuthAccessTokenSecret.class)) {
            gatherer.error(module, Message.DEVKIT_180);
        }
        if (module.getAccessTokenField() == null) {
            gatherer.error(module, Message.DEVKIT_181);
        }else{
            if (!module.getAccessTokenField().hasGetter()) {
                gatherer.error(module, Message.DEVKIT_182);
            }
            if (!module.getAccessTokenField().hasSetter()) {
                gatherer.error(module, Message.DEVKIT_183);
            }
        }
        // check types on the authorization parameters
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (!SchemaTypeConversion.isSupported(parameter.getType().asTypeMirror().toString()) &&
                        !parameter.getType().isEnum()) {
                    gatherer.error(module, Message.DEVKIT_184,parameter.getType().getName());
                }
            }
        }

        if (module.getCallbackParameters() != null) {
            for (Field field : module.getCallbackParameters()) {
                if (!field.hasSetter()) {
                    gatherer.error(module, Message.DEVKIT_185,field.getName());
                }
            }
        }

        verifyPostAuthorizationMethod(module);
    }

}
