/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import java.lang.annotation.Annotation;
import javax.lang.model.type.TypeKind;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthClientAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    protected abstract void verify(OAuthModule var1, NotificationGatherer var2) throws AnnotationVerificationException;

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        if (module instanceof OAuthModule && ((OAuthModule)module).getUserIdentifierMethod() != null) {
            if (!((Object)((OAuthModule)module).getUserIdentifierMethod().getReturnType()).toString().equals("java.lang.String")) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENIDENTIFIER_MUST_RETURN_STRING, new Object[0]);
            }
            if (!((OAuthModule)module).getUserIdentifierMethod().isPublic()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENIDENTIFIER_MUST_BE_PUBLIC, new Object[0]);
            }
            if (((OAuthModule)module).getUserIdentifierMethod().isStatic()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENIDENTIFIER_CANNOT_BE_STATIC, new Object[0]);
            }
            if (!((OAuthModule)module).getUserIdentifierMethod().getParameters().isEmpty()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENIDENTIFIER_CANNOT_HAVE_ARGS, new Object[0]);
            }
        }
        this.verify((OAuthModule)module, gatherer);
    }

    protected void verifyPostAuthorizationMethod(OAuthModule module) throws AnnotationVerificationException {
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().isPrivate()) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_BE_PRIVATE, new Object[0]);
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().getParameters().size() > 0) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_HAVE_PARAMETERS, new Object[0]);
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().isStatic()) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_BE_STATIC, new Object[0]);
        }
        if (module.getPostAuthorizationMethod() != null && module.getPostAuthorizationMethod().getReturnType().getKind() != TypeKind.VOID) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.OAUTHPOSTAUTHORIZATION_CANNOT_RETURN_VOID, new Object[0]);
        }
    }

    protected boolean classHasMethodWithParameterAnnotated(Module module, Class<? extends Annotation> annotation) {
        for (Method method : module.getMethods()) {
            for (Parameter parameter : method.getParameters()) {
                if (!parameter.hasAnnotation(annotation)) continue;
                return true;
            }
        }
        return false;
    }
}

