/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.oauth;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.oauth.AbstractOAuthClientAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;

@RequiresMavenDependencies(value={@Dependency(groupId="oauth.signpost", artifactId="signpost-core", version="[1.2.1.2]")})
public class OAuth1ClientAnnotationVerifier
extends AbstractOAuthClientAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return super.shouldVerify(module) && module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A;
    }

    public void verify(OAuthModule module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (module.getKind() == ModuleKind.GENERIC) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH_REQUIRES_CONNECTOR, new Object[0]);
        }
        if (module.getConsumerKeyField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH_REQUIRES_OAUTHCONSUMERKEY, new Object[0]);
        } else {
            if (!module.getConsumerKeyField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHCONSUMERKEY_MISSING_GETTER, new Object[0]);
            }
            if (!module.getConsumerKeyField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHCONSUMERKEY_MISSING_SETTER, new Object[0]);
            }
        }
        if (module.getConsumerSecretField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH_REQUIRES_OAUTHCONSUMERSECRET, new Object[0]);
        } else {
            if (!module.getConsumerSecretField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHCONSUMERSECRET_REQUIRES_GETTER, new Object[0]);
            }
            if (!module.getConsumerSecretField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHCONSUMERSECRET_REQUIRES_SETTER, new Object[0]);
            }
        }
        if (this.classHasMethodWithParameterAnnotated((Module)module, OAuthAccessToken.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKEN_PARAMETER_NO_LONGER_SUPPORTED, new Object[0]);
        }
        if (module.getAccessTokenField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH_REQUIRES_OAUTHACCESSTOKEN, new Object[0]);
        } else {
            if (!module.getAccessTokenField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKEN_MISSING_GETTER, new Object[0]);
            }
            if (!module.getAccessTokenField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKEN_MISSING_SETTER, new Object[0]);
            }
        }
        if (module.getAccessTokenSecretField() == null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH_REQUIRES_OAUTHACCESSTOKENSECRET, new Object[0]);
        } else {
            if (!module.getAccessTokenSecretField().hasGetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENSECRET_MISSING_GETTER, new Object[0]);
            }
            if (!module.getAccessTokenSecretField().hasSetter()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKENSECRET_MISSING_SETTER, new Object[0]);
            }
        }
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (SchemaTypeConversion.isSupported((String)((Object)parameter.getType().asTypeMirror()).toString()) || parameter.getType().isEnum()) continue;
                gatherer.error((Identifiable)module, (DevkitNotification)Message.AUTH_PARAMETER_TYPE_NOT_SUPPORTED, new Object[]{parameter.getType().getName()});
            }
        }
        if (module.getUserIdentifierMethod() != null) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTH1_DOES_NOT_SUPPORT_OAUTHACCESSTOKENIDENTIFIER, new Object[0]);
        }
        this.verifyPostAuthorizationMethod(module);
    }
}

