package org.mule.devkit.generation.oauth;


import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.lang.model.type.TypeMirror;

///**
// * Exception thrown when a message processor requires for the connector to be authorized
// * using OAuth and its not.
// */
//public class NotAuthorizedException extends Exception {
//    /**
//     * Create a new connection exception
//     *
//     * @param message Message describing what went wrong
//     */
//    public NotAuthorizedException(String message) {
//        super(message);
//    }
//
//    /**
//     * Create a new connection exception
//     *
//     * @param throwable Inner exception
//     * @param message   Message describing what went wrong
//     */
//    public NotAuthorizedException(String message, Throwable throwable) {
//        super(message, throwable);
//    }
//}
@JustOnce
public class NotAuthorizedExceptionGenerator implements ModuleGenerator {

    @Override
    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    @Override
    public List<Product> produces() {
        return Arrays.asList(Product.NOT_AUTHORIZED_EXCEPTION);
    }

    @Override
    public boolean shouldGenerate(Module module) {
        return false;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        GeneratedPackage pkg = ctx().getCodeModel()._package(module.getPackage().getName() + OAuthClientNamingConstants.OAUTH_NAMESPACE);
        GeneratedClass clazz = pkg._class(OAuthClientNamingConstants.NOT_AUTHORIZED_EXCEPTION_CLASS_NAME);

        ctx().registerProduct(Product.NOT_AUTHORIZED_EXCEPTION, clazz);

        clazz._extends(ref(Exception.class));

        GeneratedMethod notAuthorizedException = clazz.constructor(Modifier.PUBLIC);
        notAuthorizedException.param(ref(String.class), "message");
        notAuthorizedException.body().directStatement("super(message);");

        GeneratedMethod notAuthorizedExceptionExtended = clazz.constructor(Modifier.PUBLIC);
        notAuthorizedExceptionExtended.param(ref(String.class), "message");
        notAuthorizedExceptionExtended.param(ref(Throwable.class), "throwable");
        notAuthorizedExceptionExtended.body().directStatement("super(message,throwable);");
    }

    protected TypeReference ref(Class<?> clazz) {
        return ctx().getCodeModel().ref(clazz);
    }

    protected org.mule.devkit.model.code.Type ref(TypeMirror typeMirror) {
        return ctx().getCodeModel().ref(typeMirror);
    }

    protected org.mule.devkit.model.code.Type ref(Module module) {
        return ctx().getCodeModel().ref(module.asTypeMirror());
    }

    protected Context context;

    public Context ctx() {
        return context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}
