package org.mule.devkit.oauth.generation.manager;

import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;

import java.util.List;

/**
 * This generator should be used only if the OAuth2 implementation is outside the @Connector (aka: components)
 */
public class OAuth2ManagerComponentGenerator extends AbstractOAuth2ManagerGenerator {

    @Override
    public boolean shouldGenerate(Module module) {
        return OAuth2StrategyUtilsResolver.hasOAuth2Component(module);
    }

    @Override
    protected OAuthCapability getOAuthCapability(Module module) {
        return OAuth2StrategyUtilsResolver.getOAuthCapability(module);
    }

    @Override
    protected GeneratedExpression wrapAccessorConnector(Module module,Field field, GeneratedExpression connector) {
        GeneratedExpression abstractExpression = connector;
        if (module.manager().oauth2Component().get().getConfigurableFields().contains(field)){
            abstractExpression = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent(module, connector, ctx());
        }
        return abstractExpression;
    }

    @Override
    protected List<Field> getConfigurableFields(Module module) {
        List<Field> configurableFields = module.getConfigurableFields();
        configurableFields.addAll(module.manager().oauth2Component().get().getConfigurableFields());
        return configurableFields;
    }
}
