package org.mule.devkit.oauth.generation.manager;

import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

import java.util.List;

/**
 * This generator should be used only if the OAuth2 implementation is inside the @Connector
 */
public class OAuth2ManagerModuleGenerator extends AbstractOAuth2ManagerGenerator {

    @Override
    public boolean shouldGenerate(Module module) {
        return (module instanceof OAuthModule
                && ((OAuthModule)module).getOAuthVersion().equals(OAuthVersion.V2));
    }

    @Override
    protected OAuthCapability getOAuthCapability(Module module) {
        return OAuth2StrategyUtilsResolver.getOAuthCapability(module);
    }

    @Override
    protected GeneratedExpression wrapAccessorConnector(Module module,Field field, GeneratedExpression connector) {
        return connector;
    }

    @Override
    protected List<Field> getConfigurableFields(Module module) {
        return module.getConfigurableFields();
    }
}
