package org.mule.devkit.oauth.generation.manager;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.oauth.generation.adapter.OAuth1ClientAdapterGenerator;
import org.mule.security.oauth.BaseOAuth1Manager;

public class OAuth1ManagerGenerator extends AbstractOAuthManagerGenerator {

    @Override
    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule
                && ((OAuthModule)module).getOAuthVersion().equals(OAuthVersion.V10A);
    }

    @Override
    protected void doGenerate(Module module, GeneratedClass oAuthManagerClass) throws GenerationException {
         //do nothing
    }

    @Override
    protected TypeReference getExtendManagerClass() {
        return ref(BaseOAuth1Manager.class);
    }

    @Override
    protected AbstractOAuthAdapterGenerator getAdapterGenerator() {
        return new OAuth1ClientAdapterGenerator();
    }

}