/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.manager;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.slf4j.Logger;

public abstract class AbstractOAuthManagerGenerator
extends AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.MANAGED_ACCESS_TOKEN_PROCESS_TEMPLATE, Product.METADATA_ADAPTER, Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_MANAGER, Product.OAUTH_ADAPTER);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass oAuthManagerClass = this.getOAuthManagerClass(module, this.getExtendManagerClass());
        this.generateLoggerMethod(oAuthManagerClass);
        this.callGenerator(module, this.getAdapterGenerator());
        this.doGenerate(module, oAuthManagerClass);
    }

    protected abstract TypeReference getExtendManagerClass();

    protected abstract AbstractOAuthAdapterGenerator getAdapterGenerator();

    protected abstract void doGenerate(Module var1, GeneratedClass var2) throws GenerationException;

    protected void callGenerator(Module module, AbstractOAuthAdapterGenerator oauthAdapterGenerator) throws GenerationException {
        this.ctx().warn("Calling a generator from within a generator. This is not a good practice and should be changed");
        oauthAdapterGenerator.setCtx(this.ctx());
        oauthAdapterGenerator.generate(module);
    }

    private GeneratedClass getOAuthManagerClass(Module module, TypeReference superClass) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass oauthManagerClass = pkg._class(module.getClassName() + "OAuthManager", superClass);
        this.ctx().registerProduct(Product.OAUTH_MANAGER, (Identifiable)module, (Object)oauthManagerClass);
        oauthManagerClass.javadoc().add((Object)("A {@code " + oauthManagerClass.name() + "} is a wrapper around "));
        oauthManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        oauthManagerClass.javadoc().add((Object)" that adds access token management capabilities to the pojo.");
        return oauthManagerClass;
    }

    protected void generateLoggerMethod(GeneratedClass oauthManagerClass) {
        GeneratedField logger = this.generateLoggerField(oauthManagerClass);
        GeneratedMethod getLoggerMethod = oauthManagerClass.method(2, (Type)this.ref(Logger.class), "getLogger");
        getLoggerMethod.annotate(Override.class);
        getLoggerMethod.body()._return((GeneratedExpression)logger);
    }
}

