/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeMirror;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import oauth.signpost.signature.QueryStringSigningStrategy;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthMessageSigner;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.api.annotations.oauth.OAuthSigningStrategy;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.common.security.oauth.exception.UnableToAcquireRequestTokenException;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.OAuth1Connector;
import org.mule.security.oauth.OAuth2Connector;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.callback.RestoreAccessTokenCallback;
import org.mule.security.oauth.callback.SaveAccessTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthAdapterGenerator
implements ModuleGenerator {
    protected static final String REQUEST_TOKEN_FIELD_NAME = "requestToken";
    protected static final String REQUEST_TOKEN_SECRET_FIELD_NAME = "requestTokenSecret";
    protected static final String CONSUMER_FIELD_NAME = "consumer";
    public static final String VERIFIER_FIELD_NAME = "oauthVerifier";
    public static final String HAS_TOKEN_EXPIRED_METHOD_NAME = "hasTokenExpired";
    public static final String RESET_METHOD_NAME = "reset";
    public static final String AUTHORIZE_METHOD_NAME = "authorize";
    public static final String FETCH_ACCESS_TOKEN_METHOD_NAME = "fetchAccessToken";
    public static final String OAUTH_VERIFIER_FIELD_NAME = "oauthVerifier";
    public static final String REFRESH_TOKEN_FIELD_NAME = "refreshToken";
    public static final String REFRESH_TOKEN_PATTERN_FIELD_NAME = "REFRESH_TOKEN_PATTERN";
    public static final String ON_NO_TOKEN_POLICY_FIELD_NAME = "onNoTokenPolicy";
    protected static final String ENCODING = "UTF-8";
    protected static final String GRANT_TYPE = "authorization_code";
    protected static final String ACCESS_CODE_PATTERN_FIELD_NAME = "ACCESS_CODE_PATTERN";
    protected static final String AUTH_CODE_PATTERN_FIELD_NAME = "AUTH_CODE_PATTERN";
    protected static final String EXPIRATION_TIME_PATTERN_FIELD_NAME = "EXPIRATION_TIME_PATTERN";
    protected static final String EXPIRATION_FIELD_NAME = "expiration";
    protected static final String MULE_CONTEXT_FIELD_NAME = "muleContext";
    public static final String OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthSaveAccessToken";
    public static final String OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthRestoreAccessToken";
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_MANAGER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.OAUTH_ADAPTER);
    protected Context context;

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected Type ref(String fullyQualifiedClassName) {
        return this.ctx().getCodeModel().ref(fullyQualifiedClassName);
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }

    protected void generateOnNoTokenPolicyField(GeneratedClass oauthAdapter) {
        GeneratedField onNoTokenPolicy = oauthAdapter.field(4, (Type)this.ref(OnNoTokenPolicy.class), ON_NO_TOKEN_POLICY_FIELD_NAME);
        onNoTokenPolicy.assign(ExpressionFactory.direct((String)"OnNoTokenPolicy.EXCEPTION"));
        oauthAdapter.getter(onNoTokenPolicy);
        oauthAdapter.setter(onNoTokenPolicy);
    }

    protected GeneratedMethod generateCreateConsumerMethod(GeneratedClass oauthAdapter, OAuth oauth, Module module) {
        GeneratedMethod createConsumer = oauthAdapter.method(4, (Type)this.ctx().getCodeModel().VOID, "createConsumer");
        GeneratedInvocation getConsumerKey = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(module, OAuthConsumerKey.class));
        GeneratedInvocation getConsumerSecret = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(module, OAuthConsumerSecret.class));
        GeneratedField consumer = (GeneratedField)oauthAdapter.fields().get(CONSUMER_FIELD_NAME);
        createConsumer.body().assign((AssignmentTarget)consumer, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultOAuthConsumer.class)).arg((GeneratedExpression)getConsumerKey).arg((GeneratedExpression)getConsumerSecret));
        if (oauth.messageSigner().equals((Object)OAuthMessageSigner.HMAC_SHA1)) {
            createConsumer.body().invoke((GeneratedExpression)consumer, "setMessageSigner").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HmacSha1MessageSigner.class)));
        } else if (oauth.messageSigner().equals((Object)OAuthMessageSigner.PLAIN_TEXT)) {
            createConsumer.body().invoke((GeneratedExpression)consumer, "setMessageSigner").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(PlainTextMessageSigner.class)));
        }
        if (oauth.signingStrategy().equals((Object)OAuthSigningStrategy.AUTHORIZATION_HEADER)) {
            createConsumer.body().invoke((GeneratedExpression)consumer, "setSigningStrategy").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AuthorizationHeaderSigningStrategy.class)));
        } else if (oauth.signingStrategy().equals((Object)OAuthSigningStrategy.QUERY_STRING)) {
            createConsumer.body().invoke((GeneratedExpression)consumer, "setSigningStrategy").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(QueryStringSigningStrategy.class)));
        }
        return createConsumer;
    }

    protected GeneratedClass getOAuthAdapterClass(Module module, String classSuffix, TypeReference interf) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        Object previous = null;
        previous = module instanceof ManagedConnectionModule || module.usesPooling() || module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V2) ? ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass() : (TypeReference)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass oauthAdapter = pkg._class(modifiers, module.getClassName() + classSuffix, (TypeReference)previous);
        if (module instanceof OAuthModule) {
            if (((OAuthModule)module).getOAuthVersion().equals((Object)OAuthVersion.V2)) {
                oauthAdapter._implements(OAuth2Connector.class);
            } else {
                oauthAdapter._implements(OAuth1Connector.class);
            }
        }
        this.ctx().registerProduct(Product.OAUTH_ADAPTER, (Identifiable)module, (Object)oauthAdapter);
        oauthAdapter.javadoc().add((Object)("A {@code " + oauthAdapter.name() + "} is a wrapper around "));
        oauthAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        oauthAdapter.javadoc().add((Object)" that adds OAuth capabilites to the pojo.");
        return oauthAdapter;
    }

    protected GeneratedField authorizationCodeField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("oauthVerifier").getterAndSetter().build();
    }

    protected GeneratedField saveAccessTokenCallbackField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type((Type)this.ref(SaveAccessTokenCallback.class)).name(OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected GeneratedField restoreAccessTokenCallbackField(GeneratedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type((Type)this.ref(RestoreAccessTokenCallback.class)).name(OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected GeneratedMethod generateInitialiseMethod(GeneratedClass oauthAdapter) {
        GeneratedMethod initialise = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
        initialise.body().invoke(ExpressionFactory._super(), "initialise");
        return initialise;
    }

    protected void muleContextField(GeneratedClass oauthAdapter) {
        new FieldBuilder(oauthAdapter).name(MULE_CONTEXT_FIELD_NAME).type(MuleContext.class).setter().build();
    }

    protected void generateHasBeenAuthorizedMethod(OAuthModule module, GeneratedClass oauthAdapter) {
        GeneratedMethod hasBeenAuthorized = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, "hasBeenAuthorized");
        hasBeenAuthorized._throws(this.ref(NotAuthorizedException.class));
        GeneratedBlock ifAccessTokenIsNull = hasBeenAuthorized.body()._if(ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName()).isNull())._then();
        ifAccessTokenIsNull.invoke("restoreAccessToken");
        GeneratedBlock ifAccessTokenIsNull2 = ifAccessTokenIsNull._if(ExpressionFactory.invoke((String)module.getAccessTokenField().getGetter().getName()).isNull())._then();
        GeneratedInvocation newNotAuthorizedException = ExpressionFactory._new((TypeReference)this.ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        ifAccessTokenIsNull2._throw((GeneratedExpression)newNotAuthorizedException);
    }

    protected String getterMethodForFieldAnnotatedWith(Module module, Class<? extends Annotation> annotation) {
        return this.methodForFieldAnnotatedWith(module, annotation, "get");
    }

    private String methodForFieldAnnotatedWith(Module module, Class<? extends Annotation> annotation, String prefix) {
        for (Field field : module.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            return NameUtils.buildAccessor((String)prefix, (String)StringUtils.capitalize((String)field.getName()));
        }
        return null;
    }

    protected GeneratedField generateLoggerField(GeneratedClass clazz) {
        return clazz.field(20, (Type)this.ref(Logger.class), "logger", (GeneratedExpression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(clazz.dotclass()));
    }

    protected GeneratedField generateFieldForMessageProcessor(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(4, (Type)this.ref(MessageProcessor.class), name);
        expressionManager.javadoc().add((Object)"Message Processor");
        return expressionManager;
    }

    protected GeneratedField generateFieldForBoolean(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(4, (Type)this.ctx().getCodeModel().BOOLEAN, name);
        return expressionManager;
    }

    protected GeneratedField generateFieldForString(GeneratedClass messageProcessorClass, String name) {
        GeneratedField expressionManager = messageProcessorClass.field(4, (Type)this.ref(String.class), name);
        return expressionManager;
    }

    protected void generateOAuth2AuthorizeMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod authorizeMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, AUTHORIZE_METHOD_NAME);
        GeneratedVariable extraParameters = authorizeMethod.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(String.class)), "extraParameters");
        GeneratedVariable authorizationUrl = authorizeMethod.param((Type)this.ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = authorizeMethod.param((Type)this.ref(String.class), "redirectUri");
        authorizeMethod.type((Type)this.ref(String.class));
        authorizeMethod.body()._return((GeneratedExpression)oauthManager.invoke("buildAuthorizeUrl").arg((GeneratedExpression)extraParameters).arg((GeneratedExpression)authorizationUrl).arg((GeneratedExpression)redirectUri));
    }

    protected void generateOAuth1AuthorizeMethod(GeneratedClass oauthAdapter, GeneratedField oauthManager) {
        GeneratedMethod authorizeMethod = oauthAdapter.method(1, (Type)this.ctx().getCodeModel().VOID, AUTHORIZE_METHOD_NAME);
        GeneratedVariable extraParameters = authorizeMethod.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(String.class)), "extraParameters");
        GeneratedVariable requestTokenUrl = authorizeMethod.param((Type)this.ref(String.class), "requestTokenUrl");
        GeneratedVariable accessTokenUrl = authorizeMethod.param((Type)this.ref(String.class), "accessTokenUrl");
        GeneratedVariable authorizationUrl = authorizeMethod.param((Type)this.ref(String.class), "authorizationUrl");
        GeneratedVariable redirectUri = authorizeMethod.param((Type)this.ref(String.class), "redirectUri");
        authorizeMethod._throws(this.ref(UnableToAcquireRequestTokenException.class));
        authorizeMethod.type((Type)this.ref(String.class));
        authorizeMethod.body()._return((GeneratedExpression)oauthManager.invoke("buildAuthorizeUrl").arg(ExpressionFactory._this()).arg((GeneratedExpression)extraParameters).arg((GeneratedExpression)requestTokenUrl).arg((GeneratedExpression)accessTokenUrl).arg((GeneratedExpression)authorizationUrl).arg((GeneratedExpression)redirectUri));
    }

    protected GeneratedVariable generateProvider(GeneratedVariable requestTokenUrl, GeneratedVariable accessTokenUrl, GeneratedVariable authorizationUrl, GeneratedBlock block, Module module) {
        block.assign((AssignmentTarget)requestTokenUrl, Op.cond((GeneratedExpression)requestTokenUrl.isNotNull(), (GeneratedExpression)requestTokenUrl, (GeneratedExpression)ExpressionFactory._this().ref("requestTokenUrl")));
        if (module.hasFieldAnnotatedWith(OAuthScope.class)) {
            GeneratedVariable scope = block.decl((Type)this.ref(String.class), "scope", (GeneratedExpression)ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(module, OAuthScope.class)));
            GeneratedBlock ifScopeNotNull = block._if(scope.isNotNull())._then();
            GeneratedTry tryToEncodeScopeParam = ifScopeNotNull._try();
            GeneratedVariable scopeParam = tryToEncodeScopeParam.body().decl((Type)this.ref(String.class), "scopeParam", (GeneratedExpression)ExpressionFactory.lit((String)"?scope=").invoke("concat").arg((GeneratedExpression)this.ref(URLEncoder.class).staticInvoke("encode").arg((GeneratedExpression)scope).arg(ENCODING)));
            tryToEncodeScopeParam.body().assign((AssignmentTarget)requestTokenUrl, (GeneratedExpression)requestTokenUrl.invoke("concat").arg((GeneratedExpression)scopeParam));
            this.generateCatchAndReThrow(tryToEncodeScopeParam, UnsupportedEncodingException.class, RuntimeException.class);
        }
        TypeReference oauthProviderClass = this.ref(DefaultOAuthProvider.class);
        if (((OAuthModule)module).getOAuthProvider() != null) {
            oauthProviderClass = this.ref(((OAuthModule)module).getOAuthProvider());
        }
        GeneratedInvocation newProvider = ExpressionFactory._new((Type)oauthProviderClass).arg((GeneratedExpression)requestTokenUrl).arg(Op.cond((GeneratedExpression)accessTokenUrl.isNotNull(), (GeneratedExpression)accessTokenUrl, (GeneratedExpression)ExpressionFactory._this().ref("accessTokenUrl"))).arg(Op.cond((GeneratedExpression)authorizationUrl.isNotNull(), (GeneratedExpression)authorizationUrl, (GeneratedExpression)ExpressionFactory._this().ref("authorizationUrl")));
        GeneratedVariable provider = block.decl((Type)this.ref(OAuthProvider.class), "provider", (GeneratedExpression)newProvider);
        block.invoke((GeneratedExpression)provider, "setOAuth10a").arg(ExpressionFactory.TRUE);
        return provider;
    }

    protected void generateCatchAndReThrow(GeneratedTry tryStatement, Class<? extends Exception> exceptionToCatch, Class<? extends Exception> exceptionToThrow) {
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(exceptionToCatch));
        GeneratedVariable caughtException = catchBlock.param("e");
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(exceptionToThrow)).arg((GeneratedExpression)caughtException));
    }

    protected void generateCatchAndReThrow(GeneratedTry tryStatement, Class<? extends Exception> exceptionToCatch, TypeReference exceptionToThrow) {
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(exceptionToCatch));
        GeneratedVariable caughtException = catchBlock.param("e");
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)exceptionToThrow).arg((GeneratedExpression)caughtException));
    }

    protected GeneratedField generateAuthorizationUrlField(GeneratedClass generatedClass) {
        GeneratedField authorizationUrlField = generatedClass.field(4, (Type)this.ref(String.class), "authorizationUrl", ExpressionFactory._null());
        generatedClass.setter(authorizationUrlField);
        generatedClass.getter(authorizationUrlField);
        return authorizationUrlField;
    }

    protected GeneratedField generateAccessTokenUrlField(GeneratedClass generatedClass) {
        GeneratedField accessTokenUrlField = generatedClass.field(4, (Type)this.ref(String.class), "accessTokenUrl", ExpressionFactory._null());
        generatedClass.setter(accessTokenUrlField);
        generatedClass.getter(accessTokenUrlField);
        return accessTokenUrlField;
    }

    protected GeneratedField generateRequestTokenUrlField(GeneratedClass generatedClass) {
        GeneratedField requestTokenUrlField = generatedClass.field(4, (Type)this.ref(String.class), "requestTokenUrl", ExpressionFactory._null());
        generatedClass.setter(requestTokenUrlField);
        generatedClass.getter(requestTokenUrlField);
        return requestTokenUrlField;
    }
}

