/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.processors;

import java.util.Arrays;
import java.util.List;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.BaseOAuth1UnauthorizeMessageProcessor;
import org.mule.security.oauth.processor.BaseOAuth2UnauthorizeMessageProcessor;

public class UnauthorizeMessageProcessorGenerator
extends AbstractOAuthAdapterGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_ADAPTER, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.OAUTH_MANAGER, Product.CONNECTION_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule || OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module);
    }

    public void generate(Module module) throws GenerationException {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)module);
        GeneratedClass messageProcessorClass = this.getUnauthorizeMessageProcessorClass(module, oAuthCapability);
        GeneratedField logger = this.generateLoggerField(messageProcessorClass);
        if (oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2)) {
            this.generateGetOAuthManagerClass(module, messageProcessorClass);
        } else {
            this.generateGetAdapterClass(module, messageProcessorClass);
        }
    }

    private void generateGetAdapterClass(Module module, GeneratedClass messageProcessorClass) {
        GeneratedMethod getAdapterClassMethod = messageProcessorClass.method(2, (Type)this.ref(Class.class).narrow(this.ref(OAuth1Adapter.class).wildcard()), "getAdapterClass");
        getAdapterClassMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            getAdapterClassMethod.body()._return(ExpressionFactory.direct((String)(module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class")));
        } else {
            GeneratedClass oauthAdapter = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
            getAdapterClassMethod.body()._return(oauthAdapter.dotclass());
        }
    }

    private void generateGetOAuthManagerClass(Module module, GeneratedClass messageProcessorClass) {
        GeneratedClass oauthManager = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedMethod getOAuthManagerClassMethod = messageProcessorClass.method(2, (Type)this.ref(Class.class).narrow((TypeReference)oauthManager), "getOAuthManagerClass");
        getOAuthManagerClassMethod.annotate(Override.class);
        getOAuthManagerClassMethod.body()._return(oauthManager.dotclass());
    }

    private GeneratedClass getUnauthorizeMessageProcessorClass(Module module, OAuthCapability oAuthCapability) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass clazz = null;
        clazz = oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2) ? pkg._class("UnauthorizeMessageProcessor", this.ref(BaseOAuth2UnauthorizeMessageProcessor.class), new Class[]{MessageProcessor.class, FlowConstructAware.class}) : pkg._class("UnauthorizeMessageProcessor", this.ref(BaseOAuth1UnauthorizeMessageProcessor.class), new Class[]{MessageProcessor.class, FlowConstructAware.class});
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, (Identifiable)module, "unauthorize", (Object)clazz);
        return clazz;
    }
}

