/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.processors;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.processor.BaseOAuth1AuthorizeMessageProcessor;
import org.mule.security.oauth.processor.BaseOAuth2AuthorizeMessageProcessor;

public class AuthorizeMessageProcessorGenerator
extends AbstractOAuthAdapterGenerator {
    private static final String HTTP_STATUS_PROPERTY = "http.status";
    private static final String REDIRECT_HTTP_STATUS = "302";
    private static final String LOCATION_PROPERTY = "Location";
    private static final String CALLBACK_FIELD_NAME = "oauthCallback";
    private static final List<Product> CONSUMES = Arrays.asList(Product.OAUTH_ADAPTER, Product.OAUTH_MANAGER, Product.OAUTH_FETCH_ACCESS_TOKEN_MESSAGE_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof OAuthModule || OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module);
    }

    public void generate(Module module) throws GenerationException {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)module);
        GeneratedClass messageProcessorClass = this.getAuthorizeMessageProcessorClass(module, oAuthCapability);
        GeneratedField authorizeCodePattern = this.authorizationCodePatternConstant(messageProcessorClass, oAuthCapability.getVerifierRegex());
        this.generateExtraParameterFields(oAuthCapability, messageProcessorClass);
        this.generateGetAuthCodeRegexMethod(messageProcessorClass, authorizeCodePattern);
        if (oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2)) {
            this.generateGetOAuthManagerClass(module, messageProcessorClass);
        } else {
            this.generateGetAdapterClass(module, messageProcessorClass);
        }
    }

    private void generateGetAdapterClass(Module module, GeneratedClass messageProcessorClass) {
        GeneratedMethod getAdapterClassMethod = messageProcessorClass.method(2, (Type)this.ref(Class.class).narrow(this.ref(OAuth1Adapter.class).wildcard()), "getAdapterClass");
        getAdapterClassMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            getAdapterClassMethod.body()._return(ExpressionFactory.direct((String)(module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class")));
        } else {
            GeneratedClass oauthAdapter = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module);
            getAdapterClassMethod.body()._return(oauthAdapter.dotclass());
        }
    }

    private void generateGetOAuthManagerClass(Module module, GeneratedClass messageProcessorClass) {
        GeneratedClass oauthManager = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedMethod getOAuthManagerClassMethod = messageProcessorClass.method(2, (Type)this.ref(Class.class).narrow((TypeReference)oauthManager), "getOAuthManagerClass");
        getOAuthManagerClassMethod.annotate(Override.class);
        getOAuthManagerClassMethod.body()._return(oauthManager.dotclass());
    }

    private void generateGetAuthCodeRegexMethod(GeneratedClass messageProcessorClass, GeneratedField authorizeCodePattern) {
        GeneratedMethod getAuthCodeRegexMethod = messageProcessorClass.method(2, (Type)this.ref(String.class), "getAuthCodeRegex");
        getAuthCodeRegexMethod.annotate(Override.class);
        getAuthCodeRegexMethod.body()._return((GeneratedExpression)authorizeCodePattern.invoke("pattern"));
    }

    private void generateExtraParameterFields(OAuthCapability module, GeneratedClass messageProcessorClass) {
        if (module.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : module.getAuthorizationParameters()) {
                if (!SchemaTypeConversion.isSupported((String)parameter.getType().asTypeMirror().toString()) && !parameter.getType().isEnum()) continue;
                GeneratedField field = messageProcessorClass.field(4, (Type)this.ref(Object.class), parameter.getName());
                messageProcessorClass.setter(field);
                GeneratedField generatedField = messageProcessorClass.field(4, this.ref(parameter.getType().asTypeMirror()), "_" + parameter.getName() + "Type");
            }
        }
    }

    private GeneratedClass getAuthorizeMessageProcessorClass(Module module, OAuthCapability oAuthCapability) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass moduleObject = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedClass clazz = null;
        clazz = oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2) ? pkg._class("AuthorizeMessageProcessor", this.ref(BaseOAuth2AuthorizeMessageProcessor.class).narrow((TypeReference)moduleObject)) : pkg._class("AuthorizeMessageProcessor", this.ref(BaseOAuth1AuthorizeMessageProcessor.class));
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, (Identifiable)module, "authorize", (Object)clazz);
        return clazz;
    }

    protected GeneratedField authorizationCodePatternConstant(GeneratedClass oauthAdapter, String regex) {
        return new FieldBuilder(oauthAdapter).type(Pattern.class).name("AUTH_CODE_PATTERN").staticField().finalField().initialValue((GeneratedExpression)this.ref(Pattern.class).staticInvoke("compile").arg(regex)).build();
    }
}

