/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.oauth.verifier;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.verifiers.strategies.AbstractOAuthVerifier;

@RequiresMavenDependencies({
        @Dependency(groupId = "oauth.signpost", artifactId = "signpost-core", version = "[1.2.1.2]")
})
public class OAuth1ClientAnnotationVerifier extends AbstractOAuthVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return module instanceof OAuthModule && ((OAuthModule) module).getOAuthVersion() == OAuthVersion.V10A;
    }

    @Override
    protected OAuthCapability getOAuthCapability(Module module) {
        return (OAuthModule)module;
    }

    @Override
    protected Identifiable getConcreteIdentifiable(Module module) {
        return module;
    }

    @Override
    protected void doVerify(Module module, NotificationGatherer gatherer) {
        // check types on the authorization parameters
        checkAuthorizationParameter((OAuthModule) module, gatherer);

        if (classHasMethodWithParameterAnnotated(module, OAuthAccessToken.class)) {
            gatherer.error(module, Message.OAUTHACCESSTOKEN_PARAMETER_NO_LONGER_SUPPORTED);
        }

        verifyField( ((OAuthModule) module).getAccessTokenField(),gatherer,module,Message.DEOAUTH_REQUIRES_OAUTHACCESSTOKENSECRETKIT_167);


    }
}
