/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.generation.manager.factory;

import java.io.Serializable;
import java.util.HashSet;
import org.mule.api.store.ObjectStore;
import org.mule.common.security.oauth.OAuthState;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.oauth.OAuthCallbackParameterField;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.oauth.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.utils.NameUtils;
import org.mule.security.oauth.BaseOAuthClientFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;

public class OAuthClientFactoryGenerator
extends AbstractOAuthAdapterGenerator {
    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) throws GenerationException {
        OAuthCapability oAuthCapability = OAuth2StrategyUtilsResolver.getOAuthCapability((Module)module);
        GeneratedClass adapterClass = ((GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass oAuthManagerClass = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
        GeneratedClass oauthClientFactoryClass = this.getOAuthClientFactoryClass(module);
        GeneratedField oauthManager = this.generateOAuthManagerClientFactoryField(oauthClientFactoryClass, oAuthManagerClass);
        this.generateOAuthClientFactoryConstructor(oAuthManagerClass, oauthClientFactoryClass);
        this.generateGetAdapterClassMethod(module, oauthClientFactoryClass, adapterClass);
        this.generateSetCustomAdapterPropertiesMethod(module, oauthClientFactoryClass, adapterClass, oauthManager, oAuthCapability);
        this.generateSetCustomStateProperties(module, oauthClientFactoryClass, adapterClass, oAuthCapability);
    }

    private GeneratedClass getOAuthClientFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".oauth");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "OAuthClientFactory");
        objectFactory._extends(this.ref(BaseOAuthClientFactory.class));
        this.ctx().registerProduct(Product.OAUTH2_FACTORY, (Identifiable)module, (Object)objectFactory);
        return objectFactory;
    }

    private void generateOAuthClientFactoryConstructor(GeneratedClass oauthManagerClass, GeneratedClass oauthClientFactoryClass) {
        GeneratedMethod oauthClientFactoryConstructor = oauthClientFactoryClass.constructor(1);
        GeneratedVariable constructorOAuthManager = oauthClientFactoryConstructor.param((Type)this.ref(OAuth2Manager.class).narrow(this.ref(OAuth2Adapter.class)), "oauthManager");
        GeneratedVariable constructorObjectStore = oauthClientFactoryConstructor.param((Type)this.ref(ObjectStore.class).narrow(this.ref(Serializable.class)), "objectStore");
        oauthClientFactoryConstructor.body().directStatement("super(oauthManager, objectStore);");
        oauthClientFactoryConstructor.body().directStatement(String.format("this.oauthManager = (%s) oauthManager;", oauthManagerClass.name()));
    }

    private GeneratedField generateOAuthManagerClientFactoryField(GeneratedClass oauthClientFactoryClass, GeneratedClass oauthManagerClass) {
        return oauthClientFactoryClass.field(4, (Type)oauthManagerClass, "oauthManager");
    }

    private void generateSetCustomStateProperties(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass, OAuthCapability oAuthCapability) {
        GeneratedMethod setCustomStatePropertiesMethod = oauthClientFactoryClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomStateProperties");
        setCustomStatePropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomStatePropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable state = setCustomStatePropertiesMethod.param((Type)this.ref(OAuthState.class), "state");
        GeneratedVariable connector = setCustomStatePropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (OAuthCallbackParameterField field : oAuthCapability.getCallbackParameters()) {
            GeneratedExpression castedConnector = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent((Module)module, (GeneratedExpression)connector, (Context)this.ctx());
            setCustomStatePropertiesMethod.body().add((Statement)state.invoke("setCustomProperty").arg(field.getName()).arg((GeneratedExpression)castedConnector.invoke(NameUtils.buildGetter((String)field.getName()))));
        }
    }

    private void generateSetCustomAdapterPropertiesMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass, GeneratedField oauthManager, OAuthCapability oAuthCapability) {
        GeneratedExpression castedConnector;
        GeneratedMethod setCustomAdapterPropertiesMethod = oauthClientFactoryClass.method(2, (Type)this.ctx().getCodeModel().VOID, "setCustomAdapterProperties");
        setCustomAdapterPropertiesMethod.annotate(Override.class);
        GeneratedVariable adapter = setCustomAdapterPropertiesMethod.param((Type)this.ref(OAuth2Adapter.class), "adapter");
        GeneratedVariable state = setCustomAdapterPropertiesMethod.param((Type)this.ref(OAuthState.class), "state");
        GeneratedVariable connector = setCustomAdapterPropertiesMethod.body().decl((Type)adapterClass, "connector", (GeneratedExpression)ExpressionFactory.cast((Type)adapterClass, (GeneratedExpression)adapter));
        for (OAuthCallbackParameterField field : oAuthCapability.getCallbackParameters()) {
            castedConnector = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent((Module)module, (GeneratedExpression)connector, (Context)this.ctx());
            setCustomAdapterPropertiesMethod.body().add((Statement)castedConnector.invoke(NameUtils.buildSetter((String)field.getName())).arg((GeneratedExpression)state.invoke("getCustomProperty").arg(field.getName())));
        }
        for (OAuthCallbackParameterField field : module.getConfigurableFields()) {
            this.setConfigurableOn((GeneratedExpression)connector, oAuthCapability, setCustomAdapterPropertiesMethod, oauthManager, (Field)field);
        }
        if (OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module)) {
            for (OAuthCallbackParameterField field : ((OAuth2Component)module.manager().oauth2Component().get()).getConfigurableFields()) {
                castedConnector = OAuth2StrategyUtilsResolver.getOAuthConcreteComponent((Module)module, (GeneratedExpression)connector, (Context)this.ctx());
                this.setConfigurableOn(castedConnector, oAuthCapability, setCustomAdapterPropertiesMethod, oauthManager, (Field)field);
            }
        }
    }

    private void setConfigurableOn(GeneratedExpression connectorOrStrategy, OAuthCapability oAuthCapability, GeneratedMethod setCustomAdapterPropertiesMethod, GeneratedField oauthManager, Field field) {
        HashSet<Field> skippedFields = new HashSet<Field>();
        skippedFields.add(oAuthCapability.getConsumerKeyField());
        skippedFields.add(oAuthCapability.getConsumerSecretField());
        if (skippedFields.contains(field)) {
            return;
        }
        GeneratedInvocation oauthManagerConfigurableInvoker = oauthManager.invoke(NameUtils.buildGetter((String)field.getName()));
        if (field.equals(oAuthCapability.getScopeField())) {
            oauthManagerConfigurableInvoker = oauthManager.invoke("getScope");
        }
        setCustomAdapterPropertiesMethod.body().add((Statement)connectorOrStrategy.invoke(NameUtils.buildSetter((String)field.getName())).arg((GeneratedExpression)oauthManagerConfigurableInvoker));
    }

    private void generateGetAdapterClassMethod(Module module, GeneratedClass oauthClientFactoryClass, GeneratedClass adapterClass) {
        GeneratedMethod getAdapterClassMethod = oauthClientFactoryClass.method(2, (Type)this.ref(Class.class).narrow(this.ref(OAuth2Adapter.class).wildcard()), "getAdapterClass");
        getAdapterClassMethod.annotate(Override.class);
        if (module.hasRestCalls()) {
            getAdapterClassMethod.body()._return(ExpressionFactory.direct((String)(module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class")));
        } else {
            getAdapterClassMethod.body()._return(adapterClass.dotclass());
        }
    }
}

