/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.oauth.verifier;

import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.verifiers.strategies.AbstractOAuthVerifier;

@RequiresMavenDependencies(value={@Dependency(groupId="oauth.signpost", artifactId="signpost-core", version="[1.2.1.2]")})
public class OAuth1ClientAnnotationVerifier
extends AbstractOAuthVerifier {
    public boolean shouldVerify(Module module) {
        return module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A;
    }

    protected OAuthCapability getOAuthCapability(Module module) {
        return (OAuthModule)module;
    }

    protected Identifiable getConcreteIdentifiable(Module module) {
        return module;
    }

    protected void doVerify(Module module, NotificationGatherer gatherer) {
        this.checkAuthorizationParameter((OAuthModule)module, gatherer);
        if (this.classHasMethodWithParameterAnnotated(module, OAuthAccessToken.class)) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.OAUTHACCESSTOKEN_PARAMETER_NO_LONGER_SUPPORTED, new Object[0]);
        }
        this.verifyField(((OAuthModule)module).getAccessTokenField(), gatherer, (Identifiable)module, Message.DEOAUTH_REQUIRES_OAUTHACCESSTOKENSECRETKIT_167);
    }
}

