/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.rest;

import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.mule.api.annotations.rest.BinaryParam;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestPostParam;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.rest.RestCall;
import org.mule.devkit.model.module.rest.RestExceptionOn;
import org.mule.devkit.model.module.rest.RestField;
import org.mule.devkit.model.module.rest.RestModule;
import org.mule.devkit.model.module.rest.RestParameter;

public class RestClientAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasRestCalls();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (RestCall method : module.getRestCalls()) {
            if (!method.isAbstract()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_186, new Object[0]);
            }
            if (method.getThrownTypes().size() != 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_187, new Object[0]);
            }
            if (method.getExceptions() != null) {
                for (RestExceptionOn restExceptionOn : method.getExceptions()) {
                    if (restExceptionOn.getExpression() != null && !"".equals(restExceptionOn.getExpression())) continue;
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_188, new Object[0]);
                }
            }
            int nonAnnotatedParameterCount = 0;
            int binaryAnnotatedParameterCount = 0;
            for (Parameter parameter : method.getParameters()) {
                if (!(parameter.hasAnnotation(RestUriParam.class) || parameter.hasAnnotation(RestHeaderParam.class) || parameter.hasAnnotation(RestQueryParam.class) || parameter.hasAnnotation(RestPostParam.class))) {
                    ++nonAnnotatedParameterCount;
                }
                if (!parameter.hasAnnotation(BinaryParam.class)) continue;
                ++binaryAnnotatedParameterCount;
            }
            int postParameter = method.getPostParameters().size();
            if (nonAnnotatedParameterCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_189, new Object[0]);
            }
            if (nonAnnotatedParameterCount == 1 && postParameter > 0) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_190, new Object[0]);
            }
            if (method.getRestNoun() != HttpMethod.POST && postParameter > 0) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_191, new Object[0]);
            }
            if (binaryAnnotatedParameterCount <= 0) continue;
            if (binaryAnnotatedParameterCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_192, new Object[0]);
            }
            if (method.payloadIsBinary().booleanValue()) {
                RestParameter payloadParameter = method.getPayloadParameter();
                if (!payloadParameter.asType().inheritsFrom(InputStream.class)) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_193, new Object[0]);
                }
                if (method.getRestNoun() == HttpMethod.POST) continue;
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_194, new Object[0]);
                continue;
            }
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_195, new Object[0]);
        }
        for (RestField field : ((RestModule)module).getUriFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.DEVKIT_196, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getQueryFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.DEVKIT_197, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getHeaderFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.DEVKIT_198, new Object[]{field.getName()});
        }
        for (RestField field : ((RestModule)module).getPostFields()) {
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.DEVKIT_199, new Object[]{field.getName()});
        }
        Field httpClientField = module.getRestHttpClientField();
        if (httpClientField != null && !((Object)httpClientField.asTypeMirror()).toString().equals(HttpClient.class.getName())) {
            gatherer.error((Identifiable)httpClientField, (DevkitNotification)Message.DEVKIT_200, new Object[]{HttpClient.class.getName()});
        }
        if (httpClientField != null && !httpClientField.hasGetter()) {
            gatherer.error((Identifiable)httpClientField, (DevkitNotification)Message.DEVKIT_201, new Object[]{httpClientField.getName()});
        }
    }
}

