/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.rest;

import org.mule.devkit.generation.api.*;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresMavenDependencies({
        @Dependency(groupId = "org.mule.transports", artifactId = "mule-transport-http", version = "[3.0.0,4.0.0)", scope = Scope.PROVIDED)
})
public class RestClientPlugin implements Plugin {
    private List<ModuleAnnotationVerifier> annotationVerifiers;
    private List<Generator> moduleGenerators;

    public RestClientPlugin() {
        moduleGenerators = new ArrayList<Generator>();

        annotationVerifiers = new ArrayList<ModuleAnnotationVerifier>();
        annotationVerifiers.add(new RestClientAnnotationVerifier());
        annotationVerifiers.add(new HttpBasicAuthComponentVerifier());

        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new RestClientAdapterGenerator());
    }

    @Override
    public String getOptionName() {
        return null;
    }

    @Override
    public List<ModuleAnnotationVerifier> getVerifiers() {
        return annotationVerifiers;
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
