/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.rest;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import org.mule.api.annotations.rest.BasicAuthPassword;
import org.mule.api.annotations.rest.BasicAuthUsername;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;

public class HttpBasicAuthComponentVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.manager().httpBasicAuthComponent().isPresent();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        HttpBasicAuthComponent httpBasicAuthComponent = (HttpBasicAuthComponent)module.manager().httpBasicAuthComponent().get();
        if (!module.hasRestCalls()) {
            gatherer.error((Identifiable)httpBasicAuthComponent, (DevkitNotification)Message.HTTP_BASIC_AUTH_WITHOUT_RESTCALL, new Object[]{module.getName()});
        }
        this.verifyProperUserOfAnnotation(module, gatherer, httpBasicAuthComponent, BasicAuthUsername.class, 1, 1);
        this.verifyProperUserOfAnnotation(module, gatherer, httpBasicAuthComponent, BasicAuthPassword.class, 1, 0);
        ConnectionStrategiesVerifierUtils.verifyNoConnectMethods((Module)module, (NotificationGatherer)gatherer, (ConnectionComponent)httpBasicAuthComponent);
    }

    private void verifyProperUserOfAnnotation(Module module, NotificationGatherer gatherer, HttpBasicAuthComponent httpBasicAuthComponent, Class<? extends Annotation> annotationClass, int maxOccurs, int minOccurs) {
        List fieldsAnnotatedWith = httpBasicAuthComponent.getFieldsAnnotatedWith(annotationClass);
        if (fieldsAnnotatedWith.size() > maxOccurs) {
            gatherer.errorAll(fieldsAnnotatedWith, (DevkitNotification)Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, new Object[]{"@".concat(annotationClass.getSimpleName())});
        } else if (fieldsAnnotatedWith.size() < minOccurs) {
            gatherer.error((Identifiable)httpBasicAuthComponent, (DevkitNotification)Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, new Object[]{"@".concat(annotationClass.getSimpleName())});
        } else {
            this.verifyHttpAnnotatedField(module, httpBasicAuthComponent, gatherer, (Field)fieldsAnnotatedWith.get(0), annotationClass);
        }
    }

    private void verifyHttpAnnotatedField(Module module, HttpBasicAuthComponent httpBasicAuthComponent, NotificationGatherer gatherer, Field field, Class<? extends Annotation> annotationClass) {
        if (!field.asTypeMirror().toString().equals("java.lang.String")) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.HTTP_BASIC_AUTH_REQUIRES_STRING, new Object[]{"@".concat(annotationClass.getSimpleName())});
        }
        HttpBasicAuthComponentVerifier.verifyConfigurablesGettersAndSetters((ConnectionComponent)httpBasicAuthComponent, gatherer);
        HashSet<String> configurableNames = new HashSet<String>();
        for (Field moduleField : module.getConfigurableFields()) {
            configurableNames.add(moduleField.getName());
        }
        if (configurableNames.contains(field.getName())) {
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_FIELDS_CRASHES, new Object[]{field.getName(), httpBasicAuthComponent.getName(), module.getName()});
        }
    }

    public static void verifyConfigurablesGettersAndSetters(ConnectionComponent httpBasicAuthComponent, NotificationGatherer gatherer) {
        for (Field field : httpBasicAuthComponent.getConfigurableFields()) {
            if (!field.hasSetter()) {
                gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_SETTER, new Object[]{field.getName()});
            }
            if (field.hasGetter()) continue;
            gatherer.error((Identifiable)field, (DevkitNotification)Message.CONFIGURABLE_MISSING_GETTER, new Object[]{field.getName()});
        }
    }
}

