/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.rest;

import org.mule.api.annotations.rest.BasicAuthPassword;
import org.mule.api.annotations.rest.BasicAuthUsername;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;

import java.lang.annotation.Annotation;
import java.util.List;

public class HttpBasicAuthComponentVerifier extends AbstractBaseAnnotationVerifier {

    @Override
    public boolean shouldVerify(Module module) {
        return module.manager().httpBasicAuthComponent().isPresent();
    }

    @Override
    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        HttpBasicAuthComponent httpBasicAuthComponent = module.manager().httpBasicAuthComponent().get();
        if (!module.hasRestCalls()) {
            gatherer.error(httpBasicAuthComponent, Message.HTTP_BASIC_AUTH_WITHOUT_RESTCALL, module.getName());
        }
        verifyProperUserOfAnnotation(gatherer, httpBasicAuthComponent, BasicAuthUsername.class, 1, 1);
        verifyProperUserOfAnnotation(gatherer, httpBasicAuthComponent, BasicAuthPassword.class, 1, 0);
        ConnectionStrategiesVerifierUtils.verifyNoConnectMethods(gatherer, httpBasicAuthComponent);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableGetterAndSetter(gatherer, httpBasicAuthComponent);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableFields(module, gatherer, httpBasicAuthComponent);
    }

    private void verifyProperUserOfAnnotation(NotificationGatherer gatherer, HttpBasicAuthComponent httpBasicAuthComponent,
                                              Class<? extends Annotation> annotationClass,
                                              int maxOccurs, int minOccurs) {
        List<Field> fieldsAnnotatedWith = httpBasicAuthComponent.getFieldsAnnotatedWith(annotationClass);
        if (fieldsAnnotatedWith.size() > maxOccurs ){
            gatherer.errorAll(fieldsAnnotatedWith, Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, "@".concat(annotationClass.getSimpleName()));
        }else if(fieldsAnnotatedWith.size() < minOccurs){
            gatherer.error(httpBasicAuthComponent, Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, "@".concat(annotationClass.getSimpleName()));
        }else{
            if (!fieldsAnnotatedWith.get(0).asTypeMirror().toString().equals("java.lang.String")){
                gatherer.error(fieldsAnnotatedWith.get(0), Message.HTTP_BASIC_AUTH_REQUIRES_STRING, "@".concat(annotationClass.getSimpleName()));
            }
        }


    }


}
