/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.rest;

import java.lang.annotation.Annotation;
import java.util.List;
import org.mule.api.annotations.rest.BasicAuthPassword;
import org.mule.api.annotations.rest.BasicAuthUsername;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionComponent;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.verifiers.strategies.ConnectionStrategiesVerifierUtils;

public class HttpBasicAuthComponentVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.manager().httpBasicAuthComponent().isPresent();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        HttpBasicAuthComponent httpBasicAuthComponent = (HttpBasicAuthComponent)module.manager().httpBasicAuthComponent().get();
        if (!module.hasRestCalls()) {
            gatherer.error((Identifiable)httpBasicAuthComponent, (DevkitNotification)Message.HTTP_BASIC_AUTH_WITHOUT_RESTCALL, new Object[]{module.getName()});
        }
        this.verifyProperUserOfAnnotation(gatherer, httpBasicAuthComponent, BasicAuthUsername.class, 1, 1);
        this.verifyProperUserOfAnnotation(gatherer, httpBasicAuthComponent, BasicAuthPassword.class, 1, 0);
        ConnectionStrategiesVerifierUtils.verifyNoConnectMethods((NotificationGatherer)gatherer, (ConnectionComponent)httpBasicAuthComponent);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableGetterAndSetter((NotificationGatherer)gatherer, (ConnectionComponent)httpBasicAuthComponent);
        ConnectionStrategiesVerifierUtils.verifyComponentConfigurableFields((Module)module, (NotificationGatherer)gatherer, (ConnectionComponent)httpBasicAuthComponent);
    }

    private void verifyProperUserOfAnnotation(NotificationGatherer gatherer, HttpBasicAuthComponent httpBasicAuthComponent, Class<? extends Annotation> annotationClass, int maxOccurs, int minOccurs) {
        List fieldsAnnotatedWith = httpBasicAuthComponent.getFieldsAnnotatedWith(annotationClass);
        if (fieldsAnnotatedWith.size() > maxOccurs) {
            gatherer.errorAll(fieldsAnnotatedWith, (DevkitNotification)Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, new Object[]{"@".concat(annotationClass.getSimpleName())});
        } else if (fieldsAnnotatedWith.size() < minOccurs) {
            gatherer.error((Identifiable)httpBasicAuthComponent, (DevkitNotification)Message.HTTP_BASIC_AUTH_REPEATED_ANNOTATION, new Object[]{"@".concat(annotationClass.getSimpleName())});
        } else if (!((Field)fieldsAnnotatedWith.get(0)).asTypeMirror().toString().equals("java.lang.String")) {
            gatherer.error((Identifiable)fieldsAnnotatedWith.get(0), (DevkitNotification)Message.HTTP_BASIC_AUTH_REQUIRES_STRING, new Object[]{"@".concat(annotationClass.getSimpleName())});
        }
    }
}

