/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.ParameterAdapter;
import org.mule.devkit.generation.studio.editor.PatternTypeBuilder;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StringAttributeType;

public class OAuthPatternTypeBuilder
extends PatternTypeBuilder {
    public OAuthPatternTypeBuilder(Context context, Module module) {
        super(context, null, module);
    }

    @Override
    public PatternType build() {
        return this.createPatternType();
    }

    @Override
    protected PatternType createPatternType() {
        PatternType patternType = new PatternType();
        patternType.setLocalId("authorize");
        patternType.setCaption("Authorize");
        patternType.setAbstract(Boolean.valueOf(true));
        patternType.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getGlobalRefId(this.module.getModuleName()));
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        OAuthModule oAuthModule = (OAuthModule)this.module;
        AttributeCategory attributeCategoryGeneral = new AttributeCategory();
        attributeCategoryGeneral.setCaption(this.helper.formatCaption("General"));
        attributeCategoryGeneral.setDescription(this.helper.formatDescription("General"));
        Group authParametersGroup = new Group();
        authParametersGroup.setCaption(this.helper.formatCaption("Additional authorization parameters"));
        attributeCategoryGeneral.getGroup().add(authParametersGroup);
        Group stateGroup = new Group();
        stateGroup.setCaption(this.helper.formatCaption("State"));
        StringAttributeType stateAttribute = new StringAttributeType();
        stateAttribute.setName("state");
        stateAttribute.setDescription(this.helper.formatDescription("state"));
        stateAttribute.setCaption(this.helper.formatCaption("state"));
        if (oAuthModule.getAuthorizationParameters() != null) {
            for (OAuthAuthorizationParameter parameter : oAuthModule.getAuthorizationParameters()) {
                JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement((Variable)new ParameterAdapter(parameter));
                authParametersGroup.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            }
        }
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategoryGeneral);
        return patternType;
    }

    @Override
    protected String getImage() {
        return this.helper.getConnectorImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getConnectorIcon(this.module);
    }
}

