/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.studio.editor.MethodComparator;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalEndpointTypeOperationsBuilder
extends GlobalTypeBuilder {
    public GlobalEndpointTypeOperationsBuilder(Context context, Module module) {
        super(context, module);
    }

    @Override
    public GlobalType build() {
        GlobalType globalEndpointListingOps = super.build();
        globalEndpointListingOps.setExtends("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + "abstractGlobalEndpoint");
        globalEndpointListingOps.setVersions(this.buildVersionsString());
        return globalEndpointListingOps;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.createGroupWithModeSwitch(this.getTransformerMethodsSorted()));
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    private List<? extends Method> getTransformerMethodsSorted() {
        List transformer = this.module.getSourceMethods();
        Collections.sort(transformer, new MethodComparator());
        return transformer;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global endpoint");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return "global-endpoint";
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.module);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the endpoint so that other elements can reference it.";
    }

    @Override
    protected String getImage() {
        return this.helper.getEndpointImage(this.module);
    }

    @Override
    protected String getIcon() {
        return this.helper.getEndpointIcon(this.module);
    }

    @Override
    protected Boolean isAbstract() {
        return false;
    }
}

