/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioPluginActivatorGenerator
extends AbstractMuleStudioNamespaceGenerator
implements ModuleGenerator {
    private static final String ACTIVATOR_PACKAGE = "org.mule.tooling.ui.contribution";
    private static final String ACTIVATOR_CLASS_NAME = "Activator";
    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_ACTIVATOR);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    public void generate(Module module) throws GenerationException {
        String className = NameUtils.camel((String)module.getModuleName()) + ACTIVATOR_CLASS_NAME;
        GeneratedClass activatorClass = this.getActivatorClass(ACTIVATOR_PACKAGE, className);
        activatorClass.javadoc().add((Object)"The activator class controls the plug-in life cycle");
        new FieldBuilder(activatorClass).publicVisibility().staticField().finalField().type(String.class).name("PLUGIN_ID").initialValue("org.mule.tooling.ui.contribution." + module.getModuleName()).build();
        TypeReference activatorTypeRef = this.ctx().getCodeModel().directClass("org.mule.tooling.ui.contribution." + className);
        GeneratedField plugin = new FieldBuilder(activatorClass).staticField().type((Type)activatorTypeRef).name("plugin").build();
        this.generateStartMethod(activatorClass, plugin);
        this.generateStopMethod(activatorClass, plugin);
        GeneratedMethod getDefault = activatorClass.method(17, (Type)activatorTypeRef, "getDefault");
        getDefault.body()._return((GeneratedExpression)plugin);
        this.ctx().registerProduct(Product.STUDIO_ACTIVATOR, (Identifiable)module, (Object)activatorClass);
    }

    private GeneratedClass getActivatorClass(String packageName, String className) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(packageName);
        GeneratedClass clazz = pkg._class(className);
        clazz._extends(AbstractUIPlugin.class);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass activatorClass, GeneratedField plugin) {
        GeneratedMethod start = activatorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        start._throws(Exception.class);
        GeneratedVariable context = start.param(BundleContext.class, "context");
        start.body().invoke(ExpressionFactory._super(), "start").arg((GeneratedExpression)context);
        start.body().assign((AssignmentTarget)plugin, ExpressionFactory._this());
    }

    private void generateStopMethod(GeneratedClass activatorClass, GeneratedField plugin) {
        GeneratedMethod stop = activatorClass.method(1, (Type)super.ctx().getCodeModel().VOID, "stop");
        stop._throws(Exception.class);
        GeneratedVariable context = stop.param(BundleContext.class, "context");
        stop.body().assign((AssignmentTarget)plugin, ExpressionFactory._null());
        stop.body().invoke(ExpressionFactory._super(), "stop").arg((GeneratedExpression)context);
    }
}

