/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.model.module.Module;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.util.Arrays;
import java.util.List;

public class MuleStudioPluginXmlGenerator extends AbstractMuleStudioNamespaceGenerator {

    private static final String PLUGIN_XML_FILE_NAME = "plugin.xml";

    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_PLUGIN_XML);
    private static List<Product> CONSUMES = Arrays.asList(Product.STUDIO_EDITOR_XML);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        try {

            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();

            Element pluginElement = document.createElement("plugin");
            document.appendChild(pluginElement);

            Element extensionElement = document.createElement("extension");
            extensionElement.setAttribute("point", "org.mule.tooling.core.contribution");

            pluginElement.appendChild(extensionElement);

            Element externalContributionElement = document.createElement("externalContribution");
            externalContributionElement.setAttribute("contributionJar", ctx().getMavenInformation().getArtifactId() + "-" + ctx().getMavenInformation().getVersion() + ".jar");
            externalContributionElement.setAttribute("contributionLibPathInMule", "/plugins");
            externalContributionElement.setAttribute("contributionLibs", ctx().getMavenInformation().getArtifactId() + "-" + ctx().getMavenInformation().getVersion() + ".zip");
            externalContributionElement.setAttribute("contributionSources", ctx().getMavenInformation().getArtifactId() + "-" + ctx().getMavenInformation().getVersion() + "-src.jar");
            externalContributionElement.setAttribute("contributionJavaDocs", ctx().getMavenInformation().getArtifactId() + "-" + ctx().getMavenInformation().getVersion() + "-javadoc.jar");
            externalContributionElement.setAttribute("contributionNamespace", module.getXmlNamespace());
            externalContributionElement.setAttribute("contributionNamespaceFile", module.getVersionedSchemaLocation());
            externalContributionElement.setAttribute("contributionNamespacePrefix", module.getModuleName());
            externalContributionElement.setAttribute("contributionType", "cloud-connector");
            externalContributionElement.setAttribute("path", (ctx().<ModuleRelativePathBuilder>getProduct(Product.STUDIO_EDITOR_XML, module)).build(module).getRelativeToModulePath());
            externalContributionElement.setAttribute("version", module.getModuleSchemaVersion());
            externalContributionElement.setAttribute("name", module.getFriendlyName());
            externalContributionElement.setAttribute("minimumVersion", module.getMinMuleVersion().toString());
            externalContributionElement.setAttribute("contributionVersion", ctx().getMavenInformation().getVersion());

            extensionElement.appendChild(externalContributionElement);

            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();

            DOMSource source = new DOMSource(document);
            ModuleRelativePathBuilder relativePath = new ModuleRelativePathBuilder(PLUGIN_XML_FILE_NAME);
            StreamResult result = new StreamResult(ctx().getCodeModel().getCodeWriter().openBinary(null, relativePath.build(module).getFullPath()));
            transformer.transform(source, result);

            ctx().registerProduct(Product.STUDIO_PLUGIN_XML, module, relativePath);

        } catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", e);
        }
    }
}