/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.List;
import java.util.Map;
import org.mule.api.annotations.Category;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternTypeBuilder
extends BaseStudioXmlBuilder {
    public PatternTypeBuilder(Context context, Method method, Module module) {
        super(context, method, module);
    }

    public PatternType build() {
        PatternType patternType = this.createPatternType();
        if (this.method.getAnnotation(Processor.class) != null) {
            List<AttributeCategory> attributeCategories = this.processMethodParameters();
            patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(attributeCategories);
        }
        return patternType;
    }

    protected PatternType createPatternType() {
        PatternType patternType = new PatternType();
        patternType.setLocalId(this.helper.getLocalId(this.method));
        patternType.setCaption(this.helper.getFormattedCaption(this.method));
        patternType.setAbstract(Boolean.valueOf(true));
        if (this.method.getAnnotation(Processor.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.module) + this.helper.getGlobalRefId(this.module.getModuleName()));
            patternType.setReturnType(this.method.getReturnType().toString());
        } else if (this.method.getAnnotation(Transformer.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.module) + "abstractTransformer");
            patternType.setDescription(this.helper.formatDescription(this.method.getJavaDocSummary()));
        }
        Category category = (Category)this.module.getAnnotation(Category.class);
        if (category != null && StringUtils.isNotBlank((String)category.name())) {
            patternType.setCategory(category.name());
        }
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        return patternType;
    }

    protected String getImage() {
        if (this.method.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerImage(this.module);
        }
        return this.helper.getConnectorImage(this.module);
    }

    protected String getIcon() {
        if (this.method.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerIcon(this.module);
        }
        return this.helper.getConnectorIcon(this.module);
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule)this.module;
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connection"));
            AttributeType label = new AttributeType();
            label.setCaption(String.format("Use these fields to override the credentials defined in the %s connector.", this.helper.getFormattedCaption(this.module)));
            AttributeType newLine = new AttributeType();
            newLine.setCaption("");
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(label));
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(newLine));
            groupsByName.put("Connection", connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(managedConnectionModule);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory connectionAttributeCategory = new AttributeCategory();
            connectionAttributeCategory.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributeCategory.setDescription(this.helper.formatDescription("Connection"));
            attributeCategoriesByName.put("Connection", connectionAttributeCategory);
            connectionAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }
}

