/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.StudioModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthConfigNestedElementsBuilder
extends BaseStudioXmlBuilder
implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {
    public static final String OAUTH_CALLBACK_CONFIG_ELEMENT = "oauth-callback-config";
    public static final String OAUTH_STORE_CONFIG_ELEMENT = "oauth-store-config";

    protected OAuthConfigNestedElementsBuilder(Context context, Module module) {
        super(context, module);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        ArrayList<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>(2);
        OAuthModule oAuthModule = (OAuthModule)this.module;
        nesteds.add(this.objectFactory.createNested(this.createCallbackConfigNestedElementType(oAuthModule)));
        if (oAuthModule.getOAuthVersion() == OAuthVersion.V2) {
            nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(this.createStoreConfigNestedElementType()));
        }
        return nesteds;
    }

    private NestedElementType createCallbackConfigNestedElementType(OAuthModule oAuthModule) {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_CALLBACK_CONFIG_ELEMENT);
        nestedElementType.setAbstract(Boolean.valueOf(true));
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");
        StringAttributeType domainAttribute = this.helper.createStringAttributeType("Domain", "The domain name to use when setting up the callback endpoint", "domain");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)domainAttribute));
        StringAttributeType localPort = this.helper.createStringAttributeType("Local port", "The local port to use when setting up the callback endpoint", "localPort");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)localPort));
        StringAttributeType remotePort = this.helper.createStringAttributeType("Remote port", "The remote port is the port used to build the external callback URL", "remotePort");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)remotePort));
        StringAttributeType path = this.helper.createStringAttributeType("Path", "The path to use when setting up the callback endpoint", "path");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)path));
        StringAttributeType connectorRef = this.helper.createStringAttributeType("Http Connector Reference", "The Http Connector to use when setting up the callback endpoint", "connector-ref");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)connectorRef));
        if (oAuthModule.getOAuthVersion() == OAuthVersion.V2) {
            StringAttributeType defaultAccessTokenId = this.helper.createStringAttributeType("Default Access Token Id", "A Mule Expression to use as access token id", "defaultAccessTokenId");
            nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)defaultAccessTokenId));
        }
        Booleantype asyncAttribute = new Booleantype();
        asyncAttribute.setCaption(this.helper.formatCaption("Async"));
        asyncAttribute.setDescription(this.helper.formatDescription("Async"));
        asyncAttribute.setName("async");
        asyncAttribute.setDefaultValue(SchemaConstants.ASYNC_DEFAULT_VALUE);
        asyncAttribute.setFillLine(Boolean.valueOf(true));
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createGroupBoolean(asyncAttribute));
        return nestedElementType;
    }

    private NestedElementType createStoreConfigNestedElementType() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(OAUTH_STORE_CONFIG_ELEMENT);
        nestedElementType.setAbstract(Boolean.valueOf(true));
        nestedElementType.setCaption("");
        nestedElementType.setDescription("Configuration element for storage of access tokens");
        StringAttributeType objectStoreRefAttribute = this.helper.createStringAttributeType("Object store reference", "Object store reference", "objectStore-ref");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)objectStoreRefAttribute));
        return nestedElementType;
    }
}

