/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.NestedElementType;

public class PoolingProfileNestedElementBuilder
extends BaseStudioXmlBuilder {
    public static final String POOLING_PROFILE_ELEMENT = "connection-pooling-profile";
    public static final String ABSTRACT_POOLING_PROFILE = "abstractPoolingProfile";

    protected PoolingProfileNestedElementBuilder(Context context, Module module) {
        super(context, module);
    }

    public NestedElementType build() {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(POOLING_PROFILE_ELEMENT);
        nestedElementType.setAbstract(Boolean.valueOf(true));
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");
        AttributeType label = new AttributeType();
        label.setCaption("Define connection pool configuration");
        label.setDescription("");
        label.setName("poolingProfileLabel");
        nestedElementType.getRegexpOrEncodingOrString().add(this.objectFactory.createGroupLabel(label));
        IntegerType maxActiveInteger = new IntegerType();
        maxActiveInteger.setDescription("Controls the maximum number of connections that can be borrowed from the pool at one time. When set to a negative value, there is no limit to the number of connections that may be active at one time. When maxActive is exceeded, the pool is said to be exhausted.");
        maxActiveInteger.setDefaultValue(Integer.valueOf(5));
        maxActiveInteger.setCaption("Max active");
        maxActiveInteger.setFillLine(Boolean.valueOf(true));
        maxActiveInteger.setName("maxActive");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)maxActiveInteger));
        IntegerType maxIdleInteger = new IntegerType();
        maxIdleInteger.setDescription("Controls the maximum number of connections that can sit idle in the pool at any time. When set to a negative value, there is no limit to the number of connections that may be idle at one time.");
        maxIdleInteger.setDefaultValue(Integer.valueOf(5));
        maxIdleInteger.setCaption("Max idle");
        maxIdleInteger.setFillLine(Boolean.valueOf(true));
        maxIdleInteger.setName("maxIdle");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)maxIdleInteger));
        EnumType initialisationPolicyEnum = new EnumType();
        initialisationPolicyEnum.setDescription("Determines how connections in a pool should be initialized. The possible values are: INITIALISE_NONE (will not load any connection into the pool on startup), INITIALISE_ONE (will load one initial connection into the pool on startup), or INITIALISE_ALL (will load all connections in the pool on startup)");
        initialisationPolicyEnum.setCaption("Initialisation policy");
        initialisationPolicyEnum.setAlwaysFill(Boolean.valueOf(true));
        initialisationPolicyEnum.setDefaultValue("INITIALISE_ONE");
        initialisationPolicyEnum.setName("initialisationPolicy");
        EnumElement element = new EnumElement();
        element.setValue("INITIALISE_NONE");
        initialisationPolicyEnum.getOption().add(element);
        element = new EnumElement();
        element.setValue("INITIALISE_ONE");
        initialisationPolicyEnum.getOption().add(element);
        element = new EnumElement();
        element.setValue("INITIALISE_ALL");
        initialisationPolicyEnum.getOption().add(element);
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)initialisationPolicyEnum));
        EnumType exhaustedActionEnum = new EnumType();
        exhaustedActionEnum.setDescription("Specifies the behavior of the connection pool when the pool is exhausted. Possible values are: \"WHEN_EXHAUSTED_FAIL\", which will throw a NoSuchElementException, \"WHEN_EXHAUSTED_WAIT\", which will block by invoking Object.wait(long) until a new or idle object is available, or WHEN_EXHAUSTED_GROW, which will create a new connection and return it, essentially making maxActive meaningless. If a positive maxWait value is supplied, it will block for at most that many milliseconds, after which a NoSuchElementException will be thrown. If maxThreadWait is a negative value, it will block indefinitely.");
        exhaustedActionEnum.setCaption("Exhausted action");
        exhaustedActionEnum.setAlwaysFill(Boolean.valueOf(true));
        exhaustedActionEnum.setDefaultValue("WHEN_EXHAUSTED_GROW");
        exhaustedActionEnum.setName("exhaustedAction");
        element = new EnumElement();
        element.setValue("WHEN_EXHAUSTED_WAIT");
        exhaustedActionEnum.getOption().add(element);
        element = new EnumElement();
        element.setValue("WHEN_EXHAUSTED_FAIL");
        exhaustedActionEnum.getOption().add(element);
        element = new EnumElement();
        element.setValue("WHEN_EXHAUSTED_GROW");
        exhaustedActionEnum.getOption().add(element);
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)exhaustedActionEnum));
        IntegerType maxWaitInteger = new IntegerType();
        maxWaitInteger.setDescription("When exhausted action is Wait (or block) this is the amount of time in milliseconds that the pool will wait before failing. Setting a negative value will block indefinitely until an idle instance becomes available.");
        maxWaitInteger.setDefaultValue(Integer.valueOf(5));
        maxWaitInteger.setCaption("Max wait");
        maxWaitInteger.setFillLine(Boolean.valueOf(true));
        maxWaitInteger.setName("maxWait");
        nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)maxWaitInteger));
        if (this.module.getMinMuleVersion().atLeast("3.3.2")) {
            IntegerType minEvictionMillisInteger = new IntegerType();
            minEvictionMillisInteger.setDescription("Determines the minimum amount of time a connection may sit idle in the pool before it is eligible for eviction. When non-positive, no connections will be evicted from the pool due to idle time alone.");
            minEvictionMillisInteger.setDefaultValue(Integer.valueOf(1800000));
            minEvictionMillisInteger.setCaption("Min eviction (ms)");
            minEvictionMillisInteger.setFillLine(Boolean.valueOf(true));
            minEvictionMillisInteger.setName("minEvictionMillis");
            nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)minEvictionMillisInteger));
            IntegerType evictionCheckIntervalMillisInteger = new IntegerType();
            evictionCheckIntervalMillisInteger.setDescription("Specifies the number of milliseconds between runs of the connection evictor. When non-positive, no connection evictor is executed.");
            evictionCheckIntervalMillisInteger.setDefaultValue(Integer.valueOf(-1));
            evictionCheckIntervalMillisInteger.setCaption("Eviction check interval (ms)");
            evictionCheckIntervalMillisInteger.setFillLine(Boolean.valueOf(true));
            evictionCheckIntervalMillisInteger.setName("evictionCheckIntervalMillis");
            nestedElementType.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)evictionCheckIntervalMillisInteger));
        }
        return nestedElementType;
    }
}

