/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.NoMetaData;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.studio.editor.AbstractTransformerBuilder;
import org.mule.devkit.generation.studio.editor.EndpointTypeBuilder;
import org.mule.devkit.generation.studio.editor.EndpointTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.generation.studio.editor.GlobalTransformerTypeBuilder;
import org.mule.devkit.generation.studio.editor.GlobalTransformerTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.NestedsBuilder;
import org.mule.devkit.generation.studio.editor.OAuthConfigNestedElementsBuilder;
import org.mule.devkit.generation.studio.editor.OAuthPatternTypeBuilder;
import org.mule.devkit.generation.studio.editor.OAuthPatternTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.ParentCloudConnectorTypeBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypeBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypes;
import org.mule.devkit.generation.studio.editor.PoolingProfileNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.ReconnectionNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.SimpleConfigRefBuilder;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.ModuleComparator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.EndpointType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StudioModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleStudioEditorXmlGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    public static final String URI_PREFIX = "http://www.mulesoft.org/schema/mule/";
    public static final String GLOBAL_CLOUD_CONNECTOR_LOCAL_ID = "config";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_CAPTION = "General";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION = "General";
    public static final String ADVANCED_ATTRIBUTE_CATEGORY_CAPTION = "Advanced";
    public static final String GROUP_DEFAULT_CAPTION = "Basic Settings";
    private ObjectFactory objectFactory = new ObjectFactory();
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_EDITOR_XML);
    private static final String EDITOR_XML_FILE_NAME = "editors.xml";

    @Override
    public List<Product> consumes() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<org.mule.devkit.model.module.Module> modules) {
        for (org.mule.devkit.model.module.Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<org.mule.devkit.model.module.Module> processableModules(List<org.mule.devkit.model.module.Module> modules) {
        ArrayList<org.mule.devkit.model.module.Module> specificModules = new ArrayList<org.mule.devkit.model.module.Module>();
        for (org.mule.devkit.model.module.Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC && module.getKind() != ModuleKind.METADATA_CATEGORY) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void generate(List<org.mule.devkit.model.module.Module> modules) {
        List<org.mule.devkit.model.module.Module> connectorOrModule = this.getSortedConnectorAndOauthModules(modules);
        List<org.mule.devkit.model.module.Module> metaDataCategoryModules = this.getModuleByKind(modules, Arrays.asList(ModuleKind.METADATA_CATEGORY));
        for (org.mule.devkit.model.module.Module module : connectorOrModule) {
            List<org.mule.devkit.model.module.Module> usedMetaDataCategoryModules = this.getSpecificUsedMetaDataCategoryModules(metaDataCategoryModules, module);
            this.generateModule(module, usedMetaDataCategoryModules);
        }
    }

    private List<org.mule.devkit.model.module.Module> getSortedConnectorAndOauthModules(List<org.mule.devkit.model.module.Module> modules) {
        List<org.mule.devkit.model.module.Module> connectorOrModule = this.getModuleByKind(modules, Arrays.asList(ModuleKind.CONNECTOR, ModuleKind.GENERIC));
        Collections.sort(connectorOrModule, new ModuleComparator());
        return connectorOrModule;
    }

    private void executeOncePerNamespace(NamespaceType namespace, org.mule.devkit.model.module.Module module, List<org.mule.devkit.model.module.Module> usedMetaDataCategoryModules) {
        String moduleName = module.getModuleName();
        namespace.setPrefix(moduleName);
        namespace.setUrl(URI_PREFIX + moduleName);
        this.ctx().getStudioModel().addPatternTypeOperation(moduleName, (StudioModel.BuilderWithArgs)new PatternTypeOperationsChooser(this.ctx(), module));
        GlobalType globalCloudConnector = new ParentCloudConnectorTypeBuilder(this.ctx(), module).build();
        namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
        if (module instanceof ManagedConnectionModule) {
            NestedElementType poolingProfileNestedElementType = new PoolingProfileNestedElementBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNested(poolingProfileNestedElementType));
            NestedElementType reconnectionNestedElement = new ReconnectionNestedElementBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNested(reconnectionNestedElement));
        }
        this.processTransformerMethods(module, namespace);
        this.processSourceMethods(module, namespace);
    }

    private void generateModule(org.mule.devkit.model.module.Module module, List<org.mule.devkit.model.module.Module> usedMetaDataCategoryModules) {
        String moduleName = module.getModuleName();
        boolean isOAuth = module instanceof OAuthModule;
        NamespaceType namespace = this.ctx().getStudioModel().getOrCreateNamespace(module.getModuleName());
        if (isOAuth) {
            this.ctx().getStudioModel().addIsOAuth(moduleName, isOAuth);
            this.ctx().getStudioModel().addNestedElements(moduleName, (StudioModel.Builder)new OAuthConfigNestedElementsBuilder(this.ctx(), module));
        }
        this.ctx().getStudioModel().addProcessorMethods(moduleName, (StudioModel.BuilderWithArgs)new ProcessorMethodsChooser(this.ctx(), module, this.objectFactory));
        this.ctx().getStudioModel().addNestedElements(moduleName, (StudioModel.Builder)new NestedsBuilder(this.ctx(), module));
        if (!moduleName.equals(namespace.getPrefix())) {
            this.executeOncePerNamespace(namespace, module, usedMetaDataCategoryModules);
        }
        GlobalType globalCloudConnector = new GlobalCloudConnectorTypeBuilder(this.ctx(), module, usedMetaDataCategoryModules, false, "parentConfig").build();
        namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
        StudioModel.ConfigRefBuilder simpleConfigRefBuilder = this.ctx().getStudioModel().getConfigBuilderRef(moduleName);
        if (this.ctx().getStudioModel().getConfigBuilderRef(moduleName) == null) {
            simpleConfigRefBuilder = new SimpleConfigRefBuilder(this.ctx(), module);
            this.ctx().getStudioModel().addConfigBuilderRef(module.getModuleName(), simpleConfigRefBuilder);
        }
        simpleConfigRefBuilder.addRequiredType(module.getConfigElementName());
        String editorFileName = EDITOR_XML_FILE_NAME;
        ModuleRelativePathBuilder editorXMLPath = new ModuleRelativePathBuilder(editorFileName);
        this.ctx().getStudioModel().addNamespaceType(moduleName, editorXMLPath.build(module).getFullPath());
        this.ctx().registerProduct(Product.STUDIO_EDITOR_XML, (Identifiable)module, (Object)editorXMLPath);
    }

    private void processTransformerMethods(org.mule.devkit.model.module.Module module, NamespaceType namespace) {
        if (module.hasTransformers()) {
            namespace.getConnectorOrEndpointOrGlobal().add(new PatternTypeOperationsBuilder(this.ctx(), module, PatternTypes.TRANSFORMER).build());
            namespace.getConnectorOrEndpointOrGlobal().add(new AbstractTransformerBuilder(this.ctx(), module).build());
            GlobalType globalTransformer = new GlobalTransformerTypeOperationsBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
        for (TransformerMethod transformerMethod : module.getTransformerMethods()) {
            PatternType transformer = new PatternTypeBuilder(this.ctx(), (Method)transformerMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeTransformer(transformer));
            GlobalType globalTransformer = new GlobalTransformerTypeBuilder(this.ctx(), (Method)transformerMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
    }

    private void processSourceMethods(org.mule.devkit.model.module.Module module, NamespaceType namespace) {
        List sourceMethods = module.getSourceMethods();
        if (!sourceMethods.isEmpty()) {
            EndpointType endpointTypeListingOps = new EndpointTypeOperationsBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createCloudConnectorEndpoint(endpointTypeListingOps));
        }
        for (SourceMethod sourceMethod : sourceMethods) {
            EndpointType endpoint = new EndpointTypeBuilder(this.ctx(), (Method)sourceMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createCloudConnectorEndpoint(endpoint));
        }
    }

    private List<org.mule.devkit.model.module.Module> getSpecificUsedMetaDataCategoryModules(List<org.mule.devkit.model.module.Module> metaDataCategoryModules, org.mule.devkit.model.module.Module module) {
        ArrayList<org.mule.devkit.model.module.Module> usedMetaDataCategoryModules = new ArrayList<org.mule.devkit.model.module.Module>();
        ArrayList<DeclaredType> usedCategories = new ArrayList<DeclaredType>();
        if (module.getAnnotation(MetaDataScope.class) != null) {
            usedCategories.add(module.metaDataScope());
        }
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.hasMetaDataScope()) continue;
            usedCategories.add(processorMethod.metaDataScope());
        }
        block1: for (org.mule.devkit.model.module.Module metaDataCategoryModule : metaDataCategoryModules) {
            String fullQualifiedName = metaDataCategoryModule.getQualifiedName().toString();
            for (DeclaredType declaredType : usedCategories) {
                if (!fullQualifiedName.equals(declaredType.toString())) continue;
                usedMetaDataCategoryModules.add(metaDataCategoryModule);
                continue block1;
            }
        }
        return usedMetaDataCategoryModules;
    }

    private List<org.mule.devkit.model.module.Module> getModuleByKind(List<org.mule.devkit.model.module.Module> modules, List<ModuleKind> kinds) {
        ArrayList<org.mule.devkit.model.module.Module> specificModules = new ArrayList<org.mule.devkit.model.module.Module>();
        for (org.mule.devkit.model.module.Module module : modules) {
            if (!kinds.contains(module.getKind())) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessorMethodsChooser
    implements StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> {
        private org.mule.devkit.model.module.Module module;
        private ObjectFactory objectFactory;
        private Context ctx;

        public ProcessorMethodsChooser(Context ctx, org.mule.devkit.model.module.Module module, ObjectFactory objectFactory) {
            this.module = module;
            this.ctx = ctx;
            this.objectFactory = objectFactory;
        }

        public List<JAXBElement<? extends AbstractElementType>> build(Boolean isOAuth) {
            ArrayList<JAXBElement<? extends AbstractElementType>> list = new ArrayList<JAXBElement<? extends AbstractElementType>>();
            for (ProcessorMethod processorMethod : this.module.getProcessorMethods()) {
                PatternType cloudConnector = new PatternTypeBuilder(this.ctx, (Method)processorMethod, this.module).build();
                if (processorMethod.hasDynamicMetaData() || processorMethod.hasQuery() || processorMethod.hasStaticKeyMetaData() || processorMethod.hasMetaDataScope()) {
                    cloudConnector.setMetaData("dynamic");
                } else if (this.isMetaDataEnabled((Method)processorMethod, this.module)) {
                    cloudConnector.setMetaData("static");
                }
                if (processorMethod.hasStaticKeyOutputMetaData()) {
                    cloudConnector.setMetaDataStaticKey(processorMethod.getStaticKeyOutputMetaData().type());
                }
                ArrayList<String> categories = new ArrayList<String>();
                ArrayList<DeclaredType> annotationValuesCategories = new ArrayList<DeclaredType>();
                if (processorMethod.hasMetaDataScope()) {
                    annotationValuesCategories.add(processorMethod.metaDataScope());
                } else if (this.module.getAnnotation(MetaDataScope.class) != null) {
                    annotationValuesCategories.add(this.module.metaDataScope());
                }
                for (DeclaredType declaredType : annotationValuesCategories) {
                    String fullQualifiedName = declaredType.toString();
                    categories.add(fullQualifiedName.substring(fullQualifiedName.lastIndexOf(".") + 1));
                }
                if (!categories.isEmpty()) {
                    cloudConnector.setCategories(StringUtils.join(categories, (String)","));
                }
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(cloudConnector));
            }
            if (this.module instanceof OAuthModule) {
                PatternType authorize = new OAuthPatternTypeBuilder(this.ctx, "authorize", this.module).build();
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(authorize));
                PatternType unAuthorize = new OAuthPatternTypeBuilder(this.ctx, "unauthorize", this.module).build();
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(unAuthorize));
            }
            return list;
        }

        private boolean isMetaDataEnabled(Method processorMethod, org.mule.devkit.model.module.Module module) {
            return module.getMinMuleVersion().atLeastBase("3.4") && processorMethod.getAnnotation(NoMetaData.class) == null && (module.isConnector() && MetaDataSwitch.ON.equals((Object)((Connector)module.getAnnotation(Connector.class)).metaData()) || ModuleKind.GENERIC.equals((Object)module.getKind()) && MetaDataSwitch.ON.equals((Object)((Module)module.getAnnotation(Module.class)).metaData()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PatternTypeOperationsChooser
    implements StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> {
        private Context ctx;
        private org.mule.devkit.model.module.Module module;

        public PatternTypeOperationsChooser(Context ctx, org.mule.devkit.model.module.Module module) {
            this.ctx = ctx;
            this.module = module;
        }

        public JAXBElement<PatternType> build(Boolean isOAuth) {
            if (isOAuth.booleanValue()) {
                return new OAuthPatternTypeOperationsBuilder(this.ctx, this.module, PatternTypes.CLOUD_CONNECTOR).build();
            }
            return new PatternTypeOperationsBuilder(this.ctx, this.module, PatternTypes.CLOUD_CONNECTOR).build();
        }
    }
}

