/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.Generator;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.Plugin;
import org.mule.devkit.generation.api.PostProcessor;
import org.mule.devkit.generation.api.Scope;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.studio.editor.MuleStudioEditorXmlGenerator;
import org.mule.devkit.model.module.Module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresMavenDependencies({
        @Dependency(groupId = "org.eclipse", artifactId = "eclipse-workbench", version = "[3.6.1.M20100826-1330]", scope = Scope.PROVIDED),
        @Dependency(groupId = "org.eclipse", artifactId = "eclipse-runtime", version = "[3.6.0.v20100505]", scope = Scope.PROVIDED),
        @Dependency(groupId = "org.osgi", artifactId = "core", version = "[4.3.0]", scope = Scope.PROVIDED)
})
public class MuleStudioPlugin implements Plugin {

    private List<ModuleAnnotationVerifier> annotationVerifiers;
    private List<Generator> moduleGenerators;


    public MuleStudioPlugin() {
        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new MuleStudioManifestGenerator());
        moduleGenerators.add(new MuleStudioEditorXmlGenerator());
        moduleGenerators.add(new MuleStudioPluginActivatorGenerator());
        moduleGenerators.add(new MuleStudioPluginXmlGenerator());
        moduleGenerators.add(new MuleStudioIconsGenerator());

        moduleGenerators.add(new MuleStudioPluginGenerator());
        moduleGenerators.add(new StudioSiteXmlGenerator());
        moduleGenerators.add(new MuleStudioFeatureGenerator());

        moduleGenerators.add(new SerializableArchiverPlanGenerator());

        annotationVerifiers = new ArrayList<ModuleAnnotationVerifier>();

        /* Added in order to force dependency checking */
        annotationVerifiers.add(new ModuleAnnotationVerifier() {
            @Override
            public boolean shouldVerify(Module module) {
                return true;
            }

            @Override
            public void verify(Module module) throws AnnotationVerificationException {
            }
        });

        annotationVerifiers.add(new MuleStudioAnnotationVerifier());
    }

    @Override
    public String getOptionName() {
        return "enabledStudioPluginPackage";
    }

    @Override
    public List<ModuleAnnotationVerifier> getVerifiers() {
        return annotationVerifiers;
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
