/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Modifier;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;

import java.util.Arrays;
import java.util.List;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MuleStudioPluginActivatorGenerator extends AbstractMuleStudioNamespaceGenerator implements ModuleGenerator {

    private static final String ACTIVATOR_PACKAGE = "org.mule.tooling.ui.contribution";
    private static final String ACTIVATOR_CLASS_NAME = "Activator";

    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_ACTIVATOR);

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        String className = NameUtils.camel(module.getModuleName()) + ACTIVATOR_CLASS_NAME;

        GeneratedClass activatorClass = getActivatorClass(ACTIVATOR_PACKAGE, className);
        activatorClass.javadoc().add("The activator class controls the plug-in life cycle");
        new FieldBuilder(activatorClass).
                publicVisibility().
                staticField().
                finalField().
                type(String.class).
                name("PLUGIN_ID").
                initialValue("org.mule.tooling.ui.contribution." + module.getModuleName()).build();

        TypeReference activatorTypeRef = ctx().getCodeModel().directClass(ACTIVATOR_PACKAGE + "." + className);
        GeneratedField plugin = new FieldBuilder(activatorClass).staticField().type(activatorTypeRef).name("plugin").build();

        generateStartMethod(activatorClass, plugin);

        generateStopMethod(activatorClass, plugin);

        GeneratedMethod getDefault = activatorClass.method(Modifier.STATIC | Modifier.PUBLIC, activatorTypeRef, "getDefault");
        getDefault.body()._return(plugin);

        ctx().registerProduct(Product.STUDIO_ACTIVATOR, module, activatorClass);
    }

    private GeneratedClass getActivatorClass(String packageName, String className) {
        GeneratedPackage pkg = ctx().getCodeModel()._package(packageName);
        GeneratedClass clazz;
        clazz = pkg._class(className);
        clazz._extends(AbstractUIPlugin.class);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass activatorClass, GeneratedField plugin) {
        GeneratedMethod start = activatorClass.method(Modifier.PUBLIC, ctx().getCodeModel().VOID, "start");
        start._throws(Exception.class);
        GeneratedVariable context = start.param(BundleContext.class, "context");
        start.body().invoke(ExpressionFactory._super(), "start").arg(context);
        start.body().assign(plugin, ExpressionFactory._this());
    }

    private void generateStopMethod(GeneratedClass activatorClass, GeneratedField plugin) {
        GeneratedMethod stop = activatorClass.method(Modifier.PUBLIC, super.ctx().getCodeModel().VOID, "stop");
        stop._throws(Exception.class);
        GeneratedVariable context = stop.param(BundleContext.class, "context");
        stop.body().assign(plugin, ExpressionFactory._null());
        stop.body().invoke(ExpressionFactory._super(), "stop").arg(context);
    }
}