/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

import org.mule.api.annotations.ConnectivityTesting;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.MetaDataType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.util.StringUtils;

import java.util.List;
import java.util.Map;

public class GlobalCloudConnectorTypeBuilder extends GlobalTypeBuilder {

    private boolean abstrac7;
    private String globalRefId;

    public GlobalCloudConnectorTypeBuilder(Context context, Module module, boolean abstrac7, String globalRefId) {
        super(context, module);
        this.abstrac7 = abstrac7;
        this.globalRefId = globalRefId == null ? helper.getGlobalRefId(module.getModuleName()) : globalRefId;
    }

    @Override
    public GlobalType build() {
        GlobalType globalCloudConnector = super.build();
        boolean isOauth = module instanceof OAuthModule;
        ConnectivityTesting connectivityTesting = null;
        MetaDataSwitch metadata = null;

        if (module.getAnnotation(org.mule.api.annotations.Module.class) != null) {
            connectivityTesting = module.getAnnotation(org.mule.api.annotations.Module.class).connectivityTesting();
            metadata = module.getAnnotation(org.mule.api.annotations.Module.class).metaData();
        } else if (module.getAnnotation(Connector.class) != null) {
            if (MetaDataSwitch.OFF.equals(module.getAnnotation(Connector.class).metaData())) {
                metadata = MetaDataSwitch.OFF;
            } else if (module.getMetaDataRetrieverMethod() != null
                    && module.getMetaDataKeyRetrieverMethod() != null
                    && module.getMinMuleVersion().atLeastBase("3.4")) {
                metadata = MetaDataSwitch.DYNAMIC;
            } else if (module.getMinMuleVersion().atLeastBase("3.4")) {
                metadata = MetaDataSwitch.ON;
            }
            connectivityTesting = module.getAnnotation(Connector.class).connectivityTesting();
        }

        if (isOauth) {
            //We doesn't support connectivity testing for Oauth modules yet
            connectivityTesting =  ConnectivityTesting.DISABLED;
            metadata = MetaDataSwitch.ON;
        }



        if (module.getMinMuleVersion().atLeastBase("3.4") && metadata != null) {
           switch (metadata) {
               case ON:
                   globalCloudConnector.setMetaData("static");
                   break;
               case DYNAMIC:
                   globalCloudConnector.setMetaData("dynamic");
                   break;
               case OFF:
                   globalCloudConnector.setMetaData(null);
                   break;
           }
        }

        globalCloudConnector.setConnectivityTesting(connectivityTesting != null ? connectivityTesting.toString().toLowerCase() : ConnectivityTesting.OFF.toString().toLowerCase());

        // DEVKIT-368
        globalCloudConnector.setVersions(buildVersionsString());

        return globalCloudConnector;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        Group group = new Group();
        group.setId(moduleName + "GenericProperties");
        group.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupName(createNameAttributeType()));
        group.setCaption(helper.formatCaption(MuleStudioEditorXmlGenerator.GROUP_DEFAULT_CAPTION));
        return processConfigurableFields(group);
    }

    @Override
    protected void createMetaDataAttributes(Map<String,Group> groupsByName, Map<String,AttributeCategory> attributeCategoriesByName) {
        if (module.hasDynamicMetadata() || (module.isConnector()
                && module.getAnnotation(Connector.class).metaData().equals(MetaDataSwitch.ON)
                && module.getMetaDataRetrieverMethod() != null
                && module.getMetaDataKeyRetrieverMethod() != null)) {
            Group defaultGroup = groupsByName.get(GENERAL_GROUP_NAME);
            if (defaultGroup == null) {
                defaultGroup = new Group();
                defaultGroup.setCaption(helper.formatCaption(GENERAL_GROUP_NAME));
                defaultGroup.setId(StringUtils.uncapitalize(GENERAL_GROUP_NAME));
                groupsByName.put(GENERAL_GROUP_NAME, defaultGroup);

                if (attributeCategoriesByName.get(GENERAL_GROUP_NAME) == null) {
                    attributeCategoriesByName.put(GENERAL_GROUP_NAME, new AttributeCategory());
                    attributeCategoriesByName.get(GENERAL_GROUP_NAME).setCaption(GENERAL_GROUP_NAME);
                    attributeCategoriesByName.get(GENERAL_GROUP_NAME).getGroup().add(defaultGroup);
                } else {
                    attributeCategoriesByName.get(GENERAL_GROUP_NAME).getGroup().add(defaultGroup);
                }
            }

            /**
             * <useMetaData>name="useMetaData" caption="useMetaData"</useMetaData>
             */

            MetaDataType metaDataType = new MetaDataType();
            metaDataType.setName("useMetaData");
            metaDataType.setCaption("useMetaData");

            defaultGroup.getRegexpOrEncodingOrModeSwitch().add(helper.createJAXBElement(metaDataType));

        }
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (module instanceof ManagedConnectionModule) {
            ManagedConnectionModule managedConnectionModule = (ManagedConnectionModule) module;
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(helper.formatCaption(CONNECTION_GROUP_NAME));
            connectionAttributesGroup.setId(StringUtils.uncapitalize(CONNECTION_GROUP_NAME));

            groupsByName.put(CONNECTION_GROUP_NAME, connectionAttributesGroup);

            List<AttributeType> connectionAttributes = getConnectionAttributes(managedConnectionModule);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(helper.createJAXBElements(connectionAttributes));

            AttributeCategory defaultAttributeCategory = attributeCategoriesByName.get(MuleStudioEditorXmlGenerator.ATTRIBUTE_CATEGORY_DEFAULT_CAPTION);
            defaultAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }

    @Override
    protected  void createPoolingProfileAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (module instanceof ManagedConnectionModule) {
            AttributeCategory poolProfileTab = new AttributeCategory();
            poolProfileTab.setCaption("Pooling Profile");
            poolProfileTab.setDescription("Pooling profile options.");

            Group poolingProfileGroup = new Group();
            poolingProfileGroup.setCaption("Pooling Profile");
            poolingProfileGroup.setId("poolingProfile");

            NestedElementReference childElement = new NestedElementReference();
            childElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + moduleName + "/" + PoolingProfileNestedElementBuilder.POOLING_PROFILE_ELEMENT);
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(true);
            poolingProfileGroup.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(childElement));

            poolProfileTab.getGroup().add(poolingProfileGroup);
            attributeCategoriesByName.put("Pooling Profile", poolProfileTab);
        }
    }

    @Override
    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (module instanceof ManagedConnectionModule) {
            AttributeCategory reconnectionTab = new AttributeCategory();
            reconnectionTab.setCaption("Reconnection");
            reconnectionTab.setDescription("Reconnection options.");

            Group strategiesGroup = new Group();
            strategiesGroup.setCaption("Strategies");
            strategiesGroup.setId("reconnectionStrategies");

            NestedElementReference childElement = new NestedElementReference();
            childElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + "core/" + ReconnectionNestedElementBuilder.RECONNECTION_STRATEGY_ELEMENT);
            childElement.setValuePersistence("org.mule.tooling.ui.modules.core.widgets.meta.HTTPTransactionValuePersistence");
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setInplace(true);

            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(childElement));

            childElement = new NestedElementReference();
            childElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + "core/" + ReconnectionNestedElementBuilder.ABSTRACT_RECONNECTION_STRATEGY);
            childElement.setCaption("");
            childElement.setDescription("");
            childElement.setAllowSubTypes(true);
            childElement.setVisibleInDialog(false);
            childElement.setAllowedSubTypes("http://www.mulesoft.org/schema/mule/core/reconnect,http://www.mulesoft.org/schema/mule/core/reconnect-custom-strategy,http://www.mulesoft.org/schema/mule/core/reconnect-forever");

            strategiesGroup.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(childElement));

            reconnectionTab.getGroup().add(strategiesGroup);
            attributeCategoriesByName.put("Reconnection", reconnectionTab);
        }
    }

    @Override
    protected void createOAuthConfig(Map<String,Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if(module instanceof OAuthModule) {
            AttributeCategory oauthAttributeCategory = new AttributeCategory();
            oauthAttributeCategory.setCaption(helper.formatCaption("OAuth"));
            oauthAttributeCategory.setDescription(helper.formatDescription("OAuth."));

            Group oauthCallbackConfigGroup = helper.createGroup("oauthCallbackConfigGroup", "OAuth callback config");
            oauthAttributeCategory.getGroup().add(oauthCallbackConfigGroup);

            NestedElementReference oauthCallbackConfigChildElement = new NestedElementReference();
            oauthCallbackConfigChildElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + moduleName + "/" + OAuthConfigNestedElementsBuilder.OAUTH_CALLBACK_CONFIG_ELEMENT);
            oauthCallbackConfigChildElement.setCaption("");
            oauthCallbackConfigChildElement.setDescription("");
            oauthCallbackConfigChildElement.setInplace(true);
            oauthCallbackConfigGroup.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(oauthCallbackConfigChildElement));

            Group oauthStoreConfigGroup = helper.createGroup("oauthStoreConfigGroup", "OAuth object store config");
            oauthAttributeCategory.getGroup().add(oauthStoreConfigGroup);

            NestedElementReference oauthStoreConfigChildElement = new NestedElementReference();
            oauthStoreConfigChildElement.setName(MuleStudioEditorXmlGenerator.URI_PREFIX + moduleName + "/" + OAuthConfigNestedElementsBuilder.OAUTH_STORE_CONFIG_ELEMENT);
            oauthStoreConfigChildElement.setCaption("");
            oauthStoreConfigChildElement.setDescription("");
            oauthStoreConfigChildElement.setInplace(true);
            oauthStoreConfigGroup.getRegexpOrEncodingOrModeSwitch().add(objectFactory.createGroupChildElement(oauthStoreConfigChildElement));

            attributeCategoriesByName.put("OAuth", oauthAttributeCategory);
            if(module.getMinMuleVersion().atLeast("3.5")) {
                Group defaultGroup = groupsByName.get(GENERAL_GROUP_NAME);
                if (defaultGroup == null) {
                    defaultGroup = new Group();
                    defaultGroup.setCaption(helper.formatCaption(GENERAL_GROUP_NAME));
                    defaultGroup.setId(StringUtils.uncapitalize(GENERAL_GROUP_NAME));
                    groupsByName.put(GENERAL_GROUP_NAME, defaultGroup);

                    if (attributeCategoriesByName.get(GENERAL_GROUP_NAME) == null) {
                        attributeCategoriesByName.put(GENERAL_GROUP_NAME, new AttributeCategory());
                        attributeCategoriesByName.get(GENERAL_GROUP_NAME).setCaption(GENERAL_GROUP_NAME);
                        attributeCategoriesByName.get(GENERAL_GROUP_NAME).getGroup().add(defaultGroup);
                    } else {
                        attributeCategoriesByName.get(GENERAL_GROUP_NAME).getGroup().add(defaultGroup);
                    }
                }

                EnumType onNoTokenEnum = new EnumType();
                onNoTokenEnum.setCaption(helper.formatCaption("On No Token"));
                onNoTokenEnum.setDescription(helper.formatDescription("Action to take when no token is found"));
                onNoTokenEnum.setName("onNoToken");
                onNoTokenEnum.setXsdType("string");
                onNoTokenEnum.setAllowsCustom(false);
                onNoTokenEnum.setDefaultValue("EXCEPTION");
                EnumElement el1 = new EnumElement();
                el1.setValue("EXCEPTION");
                onNoTokenEnum.getOption().add(el1);
                EnumElement el2 = new EnumElement();
                el2.setValue("STOP_FLOW");
                onNoTokenEnum.getOption().add(el2);

                defaultGroup.getRegexpOrEncodingOrModeSwitch().add(helper.createJAXBElement(onNoTokenEnum));
            }
        }
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return helper.formatDescription("Global " + helper.getFormattedCaption(module) + " configuration information");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return MuleStudioEditorXmlGenerator.URI_PREFIX + module.getModuleName() + '/' + globalRefId;
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return module.getConfigElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return helper.formatDescription("Give a name to this configuration so it can be later referenced by config-ref.");
    }

    @Override
    protected String getImage() {
        return helper.getConnectorImage(module);
    }

    @Override
    protected String getIcon() {
        return helper.getConnectorIcon(module);
    }

    @Override
    protected Boolean isAbstract() {
        return abstrac7;
    }
}