/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Category;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.NewType;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StudioModel;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConfigRefBuilder
extends BaseStudioXmlBuilder
implements StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> {
    public static final String GLOBAL_REF_NAME = "config-ref";
    private static final boolean CONFIG_REF_REQUIRED = true;
    private Set<String> configElementNames = new HashSet<String>();

    public SimpleConfigRefBuilder(Context context, Module module) {
        super(context, module);
    }

    public void addRequiredType(String configElementName) {
        this.configElementNames.add(configElementName);
    }

    public JAXBElement<PatternType> build() {
        NewType globalRef = new NewType();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.configElementNames.size() > 1) {
            stringBuilder.append("$");
            for (String configElement : this.configElementNames) {
                stringBuilder.append("http://www.mulesoft.org/schema/mule/").append(this.moduleName).append('/').append(configElement);
                stringBuilder.append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else if (this.configElementNames.size() == 1) {
            stringBuilder.append("http://www.mulesoft.org/schema/mule/").append(this.moduleName).append('/').append(this.configElementNames.iterator().next());
        } else {
            throw new RuntimeException(String.format("Error: There are no required types for [%s] SimpleConfigRefBuilder.", this.moduleName));
        }
        globalRef.setRequiredType(stringBuilder.toString());
        globalRef.setName(GLOBAL_REF_NAME);
        globalRef.setCaption(this.helper.formatCaption("connector configuration"));
        globalRef.setDescription(this.helper.formatDescription("Specify which configuration to use for this invocation"));
        globalRef.setRequired(Boolean.valueOf(true));
        Group group = new Group();
        group.setId(this.helper.getGlobalRefId(this.moduleName));
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupGlobalRef(globalRef));
        group.setCaption(this.helper.formatCaption("Basic Settings"));
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(group);
        PatternType cloudConnector = new PatternType();
        cloudConnector.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        cloudConnector.setCaption(this.helper.formatCaption(this.helper.getGlobalRefId(this.moduleName)));
        cloudConnector.setLocalId(this.helper.getGlobalRefId(this.moduleName));
        cloudConnector.setDescription(this.helper.formatDescription("Interact with " + StringUtils.capitalize((String)this.moduleName)));
        cloudConnector.setAbstract(Boolean.valueOf(true));
        cloudConnector.setIcon(this.helper.getConnectorIcon(this.module));
        cloudConnector.setImage(this.helper.getConnectorImage(this.module));
        Category category = (Category)this.module.getAnnotation(Category.class);
        if (category != null && StringUtils.isNotBlank((String)category.name())) {
            cloudConnector.setCategory(category.name());
        }
        return this.objectFactory.createNamespaceTypeCloudConnector(cloudConnector);
    }
}

