/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.ClassType;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.NestedElementType;

public class ReconnectionNestedElementBuilder extends BaseStudioXmlBuilder {

    public static final String RECONNECTION_STRATEGY_ELEMENT = "reconnectionStrategyElement";
    public static final String ABSTRACT_RECONNECTION_STRATEGY = "abstractReconnectionStrategy";


    protected ReconnectionNestedElementBuilder(Context context, Module module) {
        super(context, module);
    }

    public NestedElementType build() {
        NestedElementType nestedElementType = new NestedElementType();

        nestedElementType.setLocalId(RECONNECTION_STRATEGY_ELEMENT);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");

        AttributeType label = new AttributeType();
        label.setCaption("Define how mule should attempt to handle a connection failure");
        label.setDescription("");
        label.setName("connectionLabel");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupLabel(label));

        Booleantype disableReconnectionStrategyBoolean = new Booleantype();
        disableReconnectionStrategyBoolean.setDescription("Disable reconection strategy");
        disableReconnectionStrategyBoolean.setCaption("Do not use a Reconnection strategy");
        disableReconnectionStrategyBoolean.setName("noReconnection");
        disableReconnectionStrategyBoolean.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(disableReconnectionStrategyBoolean));

        Booleantype standardReconnectionBoolean = new Booleantype();
        standardReconnectionBoolean.setDescription("A reconnection strategy that allows the user to configure how many times a reconnection should be attempted and how long to wait between attempts.");
        standardReconnectionBoolean.setCaption("Standard Reconnection");
        standardReconnectionBoolean.setName("standardReconnection");
        standardReconnectionBoolean.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(standardReconnectionBoolean));

        IntegerType reconnectionFrequency = new IntegerType();
        reconnectionFrequency.setCaption("Frequency (ms)");
        reconnectionFrequency.setDescription("How often (in ms) to reconnect");
        reconnectionFrequency.setName("frequency");
        reconnectionFrequency.setMin(1);
        reconnectionFrequency.setMax(2147483647);
        reconnectionFrequency.setStep(1);
        reconnectionFrequency.setControlled("standardReconnection");
        reconnectionFrequency.setDefaultValue(2000);
        reconnectionFrequency.setName("reconnectionFrequency");
        reconnectionFrequency.setIndented(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupInteger(reconnectionFrequency));

        IntegerType reconnectionAttemps = new IntegerType();
        reconnectionAttemps.setCaption("Reconnection Attempts");
        reconnectionAttemps.setDescription("How many reconnection attempts to make");
        reconnectionAttemps.setName("count");
        reconnectionAttemps.setMin(1);
        reconnectionAttemps.setMax(2147483647);
        reconnectionAttemps.setStep(1);
        reconnectionAttemps.setControlled("standardReconnection,!reconnectForever");
        reconnectionAttemps.setDefaultValue(2);
        reconnectionAttemps.setName("reconnectionAttemps");
        reconnectionAttemps.setIndented(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupInteger(reconnectionAttemps));

        Booleantype reconnectForever = new Booleantype();
        reconnectForever.setDescription("A reconnection strategy that retries an infinite number of times at the specified frequency.");
        reconnectForever.setCaption("Reconnect Forever");
        reconnectForever.setName("reconnectForever");
        reconnectForever.setControlled("standardReconnection");
        reconnectForever.setIndented(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupBoolean(reconnectForever));

        Booleantype customReconnection = new Booleantype();
        customReconnection.setDescription("A user-defined reconnection strategy.");
        customReconnection.setCaption("Custom Reconnection");
        customReconnection.setName("customReconnection");
        customReconnection.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupRadioBoolean(customReconnection));

        ClassType clazz = new ClassType();
        clazz.setDescription("A class that implements the RetryPolicyTemplate interface.");
        clazz.setCaption("Class");
        clazz.setName("class");
        clazz.setControlled("customReconnection");
        clazz.setIndented(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupClassname(clazz));

        NestedElementReference properties = new NestedElementReference();
        properties.setDescription("Property elements.");
        properties.setCaption("Properties");
        properties.setName("http://www.springframework.org/schema/beans/property");
        properties.setAllowMultiple(true);
        properties.setControlled("customReconnection");
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupChildElement(properties));

        return nestedElementType;
    }
}