/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.packaging;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.devkit.generation.studio.packaging.ArchiverPlan;
import org.mule.devkit.generation.studio.packaging.FutureFile;
import org.mule.devkit.generation.studio.packaging.Placeholder;
import org.mule.devkit.generation.studio.packaging.SignComponent;
import org.mule.devkit.generation.studio.packaging.Tuple;

public class PackagePlanExecutor {
    private RelativePathMap relativePathMap;
    private SignComponent signComponent;

    public PackagePlanExecutor(RelativePathMap relativePathMap, SignComponent signComponent) {
        this.relativePathMap = relativePathMap;
        this.signComponent = signComponent;
    }

    public File fileOrFail(FutureFile maybeFile, RelativePathMap relativePathMap) {
        File f = this.file(maybeFile, relativePathMap);
        if (!f.exists()) {
            throw new IllegalArgumentException("Error: Path does not exist: " + f);
        }
        return f;
    }

    public File file(FutureFile maybeFile, RelativePathMap relativePathMap) {
        return new File(((Placeholder)((Object)maybeFile.getFirst())).visit(relativePathMap), (String)maybeFile.getSecond());
    }

    public void execute(ArchiverPlan archiverPlan) {
        JarArchiver archiver = new JarArchiver();
        FutureFile manifest = archiverPlan.getManifest();
        FutureFile destFutureFile = archiverPlan.getDestFile();
        List<Tuple<FutureFile, String>> files = archiverPlan.getFiles();
        List<ArchiverPlan> children = archiverPlan.getChildren();
        List<FutureFile> directoriesToAdd = archiverPlan.getDirectoriesToAdd();
        if (destFutureFile == null || files.size() == 0) {
            throw new RuntimeException("Invalid Promise Jar Archiver");
        }
        if (manifest != null) {
            try {
                File file = this.file(manifest, this.relativePathMap);
                if (file.exists()) {
                    archiver.setManifest(file);
                }
            }
            catch (ArchiverException e) {
                throw new RuntimeException(e);
            }
        }
        for (ArchiverPlan archiverPlan2 : children) {
            this.execute(archiverPlan2);
        }
        try {
            for (Tuple tuple : files) {
                File file = this.file((FutureFile)tuple.getFirst(), this.relativePathMap);
                if (!file.exists()) continue;
                archiver.addFile(file, (String)tuple.getSecond());
            }
            for (FutureFile futureFile : directoriesToAdd) {
                File dir = this.file(futureFile, this.relativePathMap);
                if (!dir.exists()) continue;
                archiver.addDirectory(dir);
            }
            File destFile = this.file(destFutureFile, this.relativePathMap);
            archiver.setDestFile(destFile);
            archiver.createArchive();
            if (this.signComponent != null) {
                this.signComponent.sign(destFile);
            }
        }
        catch (ArchiverException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelativePathMap
    implements Placeholder.PlaceholderMap<File> {
        private String rootPath;

        public RelativePathMap(String rootPath) {
            this.rootPath = rootPath;
        }

        public RelativePathMap(File rootPath) {
            this.rootPath = rootPath.getAbsolutePath();
        }

        @Override
        public File visitPlugin(Placeholder placeholder) {
            return new File(Placeholder.UPDATE_SITE_DIRECTORY.visit(this), "plugins");
        }

        @Override
        public File visitFeature(Placeholder placeholder) {
            return new File(Placeholder.UPDATE_SITE_DIRECTORY.visit(this), "features");
        }

        @Override
        public File vistClassesDirectory(Placeholder placeholder) {
            return new File(this.rootPath, "classes");
        }

        @Override
        public File visitUpdateSite(Placeholder placeholder) {
            return new File(this.rootPath, "update-site");
        }

        @Override
        public File visitOutputDirectory(Placeholder placeholder) {
            return new File(Placeholder.GENERATED_SOURCES_DIRECTORY.visit(this), "mule");
        }

        @Override
        public File visitGeneratedSources(Placeholder placeholder) {
            return new File(this.rootPath, "generated-sources");
        }

        @Override
        public File visitRootDirectory(Placeholder placeholder) {
            return new File(this.rootPath);
        }
    }
}

