/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.api.annotations.ConnectivityTesting;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParentCloudConnectorTypeBuilder extends GlobalCloudConnectorTypeBuilder {

    public static final String PARENT_CONFIG = "parentConfig";

    public ParentCloudConnectorTypeBuilder(Context context, Module module) {
        super(context, module, Collections.EMPTY_LIST, true, null);
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        return new ArrayList<AttributeCategory>();
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return "";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return PARENT_CONFIG;
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "";
    }

    @Override
    protected String getImage() {
        return "";
    }

    @Override
    protected String getIcon() {
        return "";
    }

    @Override
    protected void setMetaDataAttribute(GlobalType globalCloudConnector, MetaDataSwitch metadata) {
        //do nothing, parent element must not have this attribute set
    }

    @Override
    protected void setConnectivityTestingAttribute(GlobalType globalCloudConnector, ConnectivityTesting connectivityTesting) {
        //do nothing, parent element must not have this attribute set
    }
}
