/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.studio.utils.ModuleComparator;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

import java.util.*;

public abstract class AbstractMuleStudioNamespaceGenerator extends AbstractMuleStudioGenerator implements MultiModuleGenerator {

    @Override
    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Module> processableModules(List<Module> modules) {
        List<Module> specificModules= new ArrayList<Module>();
        for(Module module: modules){
            if(module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC ){
                specificModules.add(module);
            }
        }
        return specificModules;
    }

    @Override
    public void generate(List<Module> modules) throws GenerationException {
        for (Module module : createListOfNamespaces(modules)) {
            generate(module);
        }
    }

    /**
     * See {@link MuleStudioFeatureGenerator#createListOfNamespaces(java.util.List)}. This code is duplicated because of DEVKIT-548
     * @param modules
     * @return
     */
    private Collection<Module> createListOfNamespaces(List<Module> modules) {
        Map<String, Module> namespaces = new HashMap<String, Module>();

        /**
         * sorting the modules because of DEVKIT-548
         */
        ArrayList<Module> sortedModules = new ArrayList<Module>(modules);
        Collections.sort(sortedModules, new ModuleComparator());

        for (Module module : sortedModules) {
            if ( (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC)
                    && (!namespaces.containsKey(module.getModuleName()))) {
                namespaces.put(module.getModuleName(), module);
            }
        }

        return namespaces.values();
    }

    /**
     * When generating the packaging for Studio, when using multi-module projects (connection management + oauth so far)
     * are implemented by inheritance. This forces devkit to sort the modules to take always the first module as connection
     * management, while the others will be "discarded". More information in DEVKIT-548.
     *
     *
     * Once devkit supports connection strategies, this complete artifact (mule-devkit-plugin-studio) must be refactored.
     *
     * @param module
     * @throws GenerationException
     */
    public abstract void generate(Module module) throws GenerationException ;

}
