/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.packaging;

import org.mule.devkit.model.code.GeneratedClass;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public class SimplePath implements Path {

    private String path;

    public SimplePath(String path) {
        this.path = path;
    }

    public SimplePath(GeneratedClass oneOrMoreFileNames) {
        this.path = pointReplace(oneOrMoreFileNames.fullName()) + ".class";
    }

    @Override
    public String getFullPath() {
        return path;
    }

    @Override
    public String getRelativeToModulePath() {
        return path;
    }

    private String pointReplace(String myStr){
        final StringBuilder result = new StringBuilder();
        final StringCharacterIterator iterator = new StringCharacterIterator(myStr);
        char character =  iterator.current();
        while (character != CharacterIterator.DONE ){
            if (character == '.') {
                result.append("/");
            }
            else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}
