/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.annotations.display.Icons;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.studio.utils.MuleStudioPathResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiModuleStudioPackageVerifier
implements MultiModuleAnnotationVerifier {
    public boolean shouldVerify(List<Module> modules) {
        return true;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind().equals((Object)ModuleKind.METADATA_CATEGORY)) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        if (!this.hasConnectorOrModule(modules)) {
            gatherer.error((Identifiable)modules.get(0), (DevkitNotification)Message.DEVKIT_PACKAGE_PROPERTY_REQUIRES_AT_LEAST_ONE_MODULE, new Object[0]);
        } else {
            this.verifyModules(modules, gatherer);
        }
    }

    private void verifyModules(List<Module> modules, NotificationGatherer gatherer) {
        List<Module> modulesToBeValidated = this.getModuleByKind(modules, Arrays.asList(ModuleKind.CONNECTOR, ModuleKind.GENERIC));
        for (Module module : modulesToBeValidated) {
            this.verifyIcon(module, gatherer);
        }
    }

    private void verifyIcon(Module module, NotificationGatherer gatherer) {
        Icons icons = (Icons)module.getAnnotation(Icons.class);
        String connectorSmall = String.format("../../../icons/%s-connector-24x16.png", module.getModuleName());
        String connectorLarge = String.format("../../../icons/%s-connector-48x32.png", module.getModuleName());
        String transformerSmall = String.format("../../../icons/%s-transformer-24x16.png", module.getModuleName());
        String transformerLarge = String.format("../../../icons/%s-transformer-48x32.png", module.getModuleName());
        String endpointSmall = String.format("../../../icons/%s-endpoint-24x16.png", module.getModuleName());
        String endpointLarge = String.format("../../../icons/%s-endpoint-48x32.png", module.getModuleName());
        if (icons != null) {
            connectorSmall = icons.connectorSmall();
            connectorLarge = icons.connectorLarge();
            transformerSmall = icons.transformerSmall();
            transformerLarge = icons.transformerLarge();
            endpointSmall = icons.endpointSmall();
            endpointLarge = icons.endpointLarge();
        }
        this.checkFile(connectorSmall, module, gatherer);
        this.checkFile(connectorLarge, module, gatherer);
        if (module.hasTransformers()) {
            this.checkFile(transformerSmall, module, gatherer);
            this.checkFile(transformerLarge, module, gatherer);
        }
        if (module.hasSources()) {
            this.checkFile(endpointSmall, module, gatherer);
            this.checkFile(endpointLarge, module, gatherer);
        }
    }

    private void checkFile(String fileName, Module module, NotificationGatherer gatherer) {
        File fileToCopy = MuleStudioPathResolver.getFileResolvingPackages(module, fileName);
        if (!fileToCopy.exists()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.MISSING_ICON, new Object[]{module.getModuleName(), fileToCopy.getAbsolutePath()});
        }
    }

    private List<Module> getModuleByKind(List<Module> modules, List<ModuleKind> kinds) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!kinds.contains(module.getKind())) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    private boolean hasConnectorOrModule(List<Module> modules) {
        boolean hasConnectorOrModule = false;
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            hasConnectorOrModule = true;
        }
        return hasConnectorOrModule;
    }
}

