/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.utils.SerializationUtils;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableArchiverPlanGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    public static final String PACKAGE_DESCRIPTOR_PATH = "package.descriptor";
    private static final List<Product> CONSUMES = Arrays.asList(Product.STUDIO_FEATURE);

    @Override
    public List<Product> consumes() {
        return CONSUMES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        OutputStream objectOutputStream = null;
        try {
            OutputStream outputStream = this.ctx().getCodeModel().getCodeWriter().openBinary(null, PACKAGE_DESCRIPTOR_PATH);
            SerializationUtils.save((OutputStream)outputStream, (Object)this.ctx().getProduct(Product.STUDIO_FEATURE));
        }
        catch (IOException e) {
            throw new GenerationException(String.format("Could not create package descriptor file: [%s] for Studio plugin: ", PACKAGE_DESCRIPTOR_PATH) + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(objectOutputStream);
        }
    }
}

