/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.studio.editor;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParentCloudConnectorTypeBuilder extends GlobalCloudConnectorTypeBuilder {

    public static final String PARENT_CONFIG = "parentConfig";

    public ParentCloudConnectorTypeBuilder(Context context, Module module) {
        super(context, module, true, null);
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        //do nothing, parent element must not have this attribute set
    }

    @Override
    protected void buildMetaDataAttr(GlobalType globalCloudConnector, boolean dynamicMetadata) {
        //do nothing, parent element must not have this attribute set
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        return new ArrayList<AttributeCategory>();
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return "";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return PARENT_CONFIG;
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "";
    }

    @Override
    protected String getImage() {
        return "";
    }

    @Override
    protected String getIcon() {
        return "";
    }

    @Override
    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        //do nothing, parent element must not have this attribute set
    }

    /**
     * TODO: overwriting this method for compatibility issues. Check if caption (from <global-cloud-connector localId="parentConfig" caption="XYZ")
     * can be discarded or changed into a general string
     * @return
     */
    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module);
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod(){
        throw new RuntimeException("This should have not happen, as a parent module was not initialized for a managed connection management");
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return Collections.EMPTY_LIST;
    }
}
