package org.mule.devkit.generation.studio.editor.callback;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.schema.SchemaConstants;
import org.mule.devkit.model.studio.*;

import javax.xml.bind.JAXBElement;
import java.util.List;

public abstract class AbstractCallbackNestedElementBuilder extends BaseStudioXmlBuilder implements StudioModel.Builder<List<JAXBElement<? extends AbstractElementType>>> {

    protected AbstractCallbackNestedElementBuilder(Context context, Module module) {
        super(context, module);
    }

    protected NestedElementType createCallbackConfigNestedElementType(String localIDElement) {
        NestedElementType nestedElementType = new NestedElementType();
        nestedElementType.setLocalId(localIDElement);
        nestedElementType.setAbstract(true);
        nestedElementType.setCaption("");
        nestedElementType.setDescription("");

        StringAttributeType domainAttribute = helper.createStringAttributeType("Domain", "The domain name to use when setting up the callback endpoint", SchemaConstants.DOMAIN_ATTRIBUTE_NAME);
        domainAttribute.setRequired(true);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(domainAttribute));

        StringAttributeType localPort = helper.createStringAttributeType("Local port", "The local port to use when setting up the callback endpoint", SchemaConstants.LOCAL_PORT_ATTRIBUTE_NAME);
        localPort.setRequired(true);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(localPort));

        StringAttributeType remotePort = helper.createStringAttributeType("Remote port", "The remote port is the port used to build the external callback URL", SchemaConstants.REMOTE_PORT_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(remotePort));

        StringAttributeType path = helper.createStringAttributeType("Path", "The path to use when setting up the callback endpoint", SchemaConstants.PATH_ATTRIBUTE_NAME);
        path.setRequired(true);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(path));

        StringAttributeType connectorRef = helper.createStringAttributeType("Http Connector Reference", "The Http Connector to use when setting up the callback endpoint", SchemaConstants.CONNECTOR_REF_ATTRIBUTE_NAME);
        nestedElementType.getRegexpOrEncodingOrString().add(helper.createJAXBElement(connectorRef));

        addCustomElements(nestedElementType);

        Booleantype asyncAttribute = new Booleantype();
        asyncAttribute.setCaption(helper.formatCaption("Async"));
        asyncAttribute.setDescription(helper.formatDescription("Async"));
        asyncAttribute.setName(SchemaConstants.ASYNC_ATTRIBUTE_NAME);
        asyncAttribute.setDefaultValue(SchemaConstants.ASYNC_DEFAULT_VALUE);
        asyncAttribute.setFillLine(true);
        nestedElementType.getRegexpOrEncodingOrString().add(objectFactory.createGroupBoolean(asyncAttribute));
        return nestedElementType;
    }

    /**
     * Hook added to mantain the same way of displaying elements in Studio when using connectors with OAuth2 enable.
     * The idea is to hook more properties before the "Async" checkbox
     *
     * @param nestedElementType the list of elements that had been previously filled with "domain, local port, remote port, path and http connector-ref" attributes
     */
    protected abstract void addCustomElements(NestedElementType nestedElementType);
}
