/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio;

import org.mule.devkit.generation.api.*;
import org.mule.devkit.generation.api.annotations.Dependency;
import org.mule.devkit.generation.api.annotations.RequiresMavenDependencies;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.generation.studio.editor.MuleStudioEditorXmlGenerator;
import org.mule.devkit.model.module.Module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RequiresMavenDependencies({
        @Dependency(groupId = "org.eclipse", artifactId = "eclipse-workbench", version = "[3.6.1.M20100826-1330]", scope = Scope.PROVIDED),
        @Dependency(groupId = "org.eclipse", artifactId = "eclipse-runtime", version = "[3.6.0.v20100505]", scope = Scope.PROVIDED),
        @Dependency(groupId = "org.osgi", artifactId = "core", version = "[4.3.0]", scope = Scope.PROVIDED)
})
public class MuleStudioPlugin implements Plugin {

    private List<Verifier> verifiers;
    private List<Generator> moduleGenerators;


    public MuleStudioPlugin() {
        initializeGenerators();
        initializeVerifiers();
    }

    private void initializeGenerators() {
        moduleGenerators = new ArrayList<Generator>();
        moduleGenerators.add(new MuleStudioManifestGenerator());
        moduleGenerators.add(new MuleStudioEditorXmlGenerator());
        moduleGenerators.add(new MuleStudioPluginActivatorGenerator());
        moduleGenerators.add(new MuleStudioPluginXmlGenerator());
        moduleGenerators.add(new MuleStudioIconsGenerator());

        moduleGenerators.add(new MuleStudioPluginGenerator());
        moduleGenerators.add(new StudioSiteXmlGenerator());
        moduleGenerators.add(new MuleStudioFeatureGenerator());

        moduleGenerators.add(new SerializableArchiverPlanGenerator());
    }

    private void initializeVerifiers() {
        verifiers = new ArrayList<Verifier>();

        /* Added in order to force dependency checking */
        verifiers.add(new ModuleAnnotationVerifier() {
            @Override
            public boolean shouldVerify(Module module) {
                return true;
            }

            @Override
            public void verify(Module module,NotificationGatherer gatherer) throws AnnotationVerificationException {
            }
        });

        verifiers.add(new MultiModuleStudioPackageVerifier());
        verifiers.add(new ConfigRequiredLibrariesVerifier());
    }

    @Override
    public String getOptionName() {
        return "enabledStudioPluginPackage";
    }

    @Override
    public List<Verifier> getVerifiers() {
        return verifiers;
    }

    @Override
    public List<Generator> getGenerators() {
        return moduleGenerators;
    }

    @Override
    public List<PostProcessor> getPostProcessors() {
        return Collections.emptyList();
    }
}
