/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.studio.editor;

import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.annotations.param.Payload;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.oauth.OAuthAuthorizationParameter;
import org.mule.devkit.model.visitor.ModelVisitor;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Adapts a {@link OAuthAuthorizationParameter} object to {@link Parameter} ada
 */
public class ParameterAdapter implements Parameter {

    private OAuthAuthorizationParameter oAuthAuthorizationParameter;

    public ParameterAdapter(OAuthAuthorizationParameter oAuthAuthorizationParameter) {
        this.oAuthAuthorizationParameter = oAuthAuthorizationParameter;
    }

    @Override
    public boolean shouldBeIgnored() {
        return false;
    }

    @Override
    public GenericType getGenericType() {
        return null;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public boolean isQueryPart() {
        return false;
    }

    @Override
    public String getJavaType() {
        return oAuthAuthorizationParameter.getType().unwrap().toString();
    }

    @Override
    public boolean isOptional() {
        return oAuthAuthorizationParameter.isOptional();
    }

    @Override
    public boolean isPayload() { return false; }

    @Override
    public boolean hasSizeLimit() {
        return false;
    }

    @Override
    public boolean hasPattern() {
        return false;
    }

    @Override
    public String getPattern() {
        return null;
    }

    @Override
    public int getMinSizeLimit() {
        return -1;
    }

    @Override
    public int getMaxSizeLimit() {
        return -1;
    }


    @Override
    public boolean hasDefaultValue() {
        return oAuthAuthorizationParameter.getDefaultValue() != null;
    }

    @Override
    public String getDefaultValue() {
        return oAuthAuthorizationParameter.getDefaultValue();
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public Element unwrap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeMirror asTypeMirror() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type asType() {
        return oAuthAuthorizationParameter.getType();
    }

    @Override
    public String getName() {
        return oAuthAuthorizationParameter.getName();
    }

    @Override
    public boolean isReservedIdentifier() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return Collections.emptyList();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> aClass) {
        return null;
    }

    @Override
    public boolean hasJavaDocTag(String tagName) {
        return false;
    }

    @Override
    public String getJavaDocSummary() {
        return oAuthAuthorizationParameter.getName();
    }

    @Override
    public String getJavaDocTagContent(String tagName) {
        return null;
    }

    @Override
    public String getJavaDocParameterSummary(String paramName) {
        return oAuthAuthorizationParameter.getName();
    }

    @Override
    public String getThrowsComment(String exceptionClassName) {
        return null;
    }

    @Override
    public List<Type> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public List<Type> getXmlDeclaredChilds() {
        return new ArrayList<Type>();
    }

    @Override
    public boolean hasTypeArguments() {
        return false;
    }

    @Override
    public Identifiable parent() {
        return this;
    }

    @Override
    public void accept(ModelVisitor visitor) {
    }

    @Override
    public String getAlternativeName() {
        return getName();
    }

    @Override
    public boolean isRefOnly() {
        return false;
    }

    @Override
    public boolean hasEmailPattern() {
        return false;
    }

    @Override
    public String getEmailDomain() {
        return null;
    }

    @Override
    public boolean hasDefaultEmailDomain() {
        return false;
    }

    @Override
    public boolean isMetaDataKey() {
        return getAnnotation(MetaDataKeyParam.class) != null;
    }

    @Override
    public boolean isMetaDataStaticKey() {
        return getAnnotation(MetaDataStaticKey.class) != null;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> aClazz){
        return false;
    }

    @Override
    public boolean hasDefaultPayload() { return hasAnnotation(Payload.class) || getAnnotation(Default.class).value().equals("#[payload]");}


}
