package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.Group;

import java.util.*;

public class GlobalCloudConnectorModuleBuilder extends GlobalCloudConnectorTypeBuilder {

    public GlobalCloudConnectorModuleBuilder(Context context, Module module, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, module.testConnectivityMethod());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = module.getConfigurableFields();
        if (isOAuthModule()) {
            configurableFields.removeAll(getOAuthConfigurableFields());
        }
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return module.getConfigElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module);
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return helper.formatDescription("Global " + helper.getFormattedCaption(module) + " configuration information");
    }

    @Override
    protected boolean hasConnectionMethod() {
        return module instanceof ManagedConnectionModule;
    }

    @Override
    protected ConnectMethod connectMethod(){
        if (! (module instanceof ManagedConnectionModule)){
            throw new RuntimeException("This should have not happen, as this module was not initialized for a managed connection management");
        }
        return ((ConnectionManagementCapability) module).getConnectMethod();
    }

    @Override
    protected void createOAuthConfig(Map<String,Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if(module instanceof OAuthModule) {
            buildOAuthConfig(groupsByName, attributeCategoriesByName);
        }
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        if (hasConnectionMethod()){
            return getConnectionAttributes((ConnectionManagementCapability) module);
        }
        if (isOAuthModule()){
            return getConnectionAttributes(getOAuthConfigurableFields());
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * Overriding this to generate same xml editors for old behaviour where overriding at processor level was the way to go,
     * rather than having MELs at global element.
     *
     * @param attributeType
     * @param variable
     */
    protected void setRequiredConnectionParameter(AttributeType attributeType, Variable variable) {
        if (hasConnectionMethod()){
            //we set the value to false, as it could be overriden at processor level
            attributeType.setRequired(false);
        }else{
            super.setRequiredConnectionParameter(attributeType, variable);
        }
    }

    /**
     *
     * @return
     */
    private List<Field> getOAuthConfigurableFields() {
        if (!isOAuthModule()){
            throw new RuntimeException("This should have not happen, as this module was not initialized for a OAuth2 type");
        }
        OAuthModule oAuthModule = (OAuthModule) module;
        List<Field> oauthFields = new ArrayList<>();
        oauthFields.add(oAuthModule.getConsumerKeyField());
        oauthFields.add(oAuthModule.getConsumerSecretField());
        if (oAuthModule.getScopeField() != null){
            oauthFields.add(oAuthModule.getScopeField());
        }
        return oauthFields;
    }

    private boolean isOAuthModule() {
        return (module instanceof OAuthModule);
    }
}
