package org.mule.devkit.generation.studio.utils;

import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

import java.util.Comparator;

/**
 * Sorts the modules according to their types, where Connection Management go first against Oauth ones.
 * This is a fix for multi modules (see DEVKIT-548)
 */
public class ModuleComparator implements Comparator<Module> {
    /**
     * Compares two modules, and sorts them using their types. Where Connection management modules have precedence against Oauth ones.
     *
     * @param m a ManagedConnectionModule/OAuthModule to be tested
     * @param m2 a ManagedConnectionModule/OAuthModule to be tested
     * @return a -1, 0, or 1 as the first module {@code m} is less than, equal to, or greater than the second module {@code m2}.
     */
    @Override
    public int compare(Module m, Module m2) {
        int res = 0;
        boolean mIsConnectionManagement = m instanceof ManagedConnectionModule;
        boolean m2IsConnectionManagement = m2 instanceof ManagedConnectionModule;
        if ( mIsConnectionManagement ){
            res = -1;
        } else if ( m2IsConnectionManagement ){
            res = 1;
        }
        return res;
    }
}
