/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.DeclaredType;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.display.UserDefinedMetaData;
import org.mule.api.callback.HttpCallback;
import org.mule.devkit.api.transformer.TransformingValue;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.global.factory.AbstractGlobalElementResolver;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.studio.editor.AbstractTransformerBuilder;
import org.mule.devkit.generation.studio.editor.CacheConfigNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.EndpointTypeBuilder;
import org.mule.devkit.generation.studio.editor.EndpointTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.GlobalTransformerTypeBuilder;
import org.mule.devkit.generation.studio.editor.GlobalTransformerTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.NestedsBuilder;
import org.mule.devkit.generation.studio.editor.OAuthPatternTypeBuilder;
import org.mule.devkit.generation.studio.editor.OAuthPatternTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.ParentCloudConnectorTypeBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypeBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypeOperationsBuilder;
import org.mule.devkit.generation.studio.editor.PatternTypes;
import org.mule.devkit.generation.studio.editor.PoolingProfileNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.ReconnectionNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.SimpleConfigRefBuilder;
import org.mule.devkit.generation.studio.editor.callback.HttpCallbackNestedElementBuilder;
import org.mule.devkit.generation.studio.editor.callback.OAuthConfigNestedElementsBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorConfigurationBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorConnectionManagementBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorHttpBasicAuthBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorModuleBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorOAuthBuilder;
import org.mule.devkit.generation.studio.editor.globalcloudconnector.GlobalCloudConnectorWsdlProviderBuilder;
import org.mule.devkit.generation.studio.editor.ws.InvokeWsdlPatternTypeBuilder;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.ModuleComparator;
import org.mule.devkit.generation.utils.OAuth2StrategyUtilsResolver;
import org.mule.devkit.generation.utils.global.element.GlobalElementFactory;
import org.mule.devkit.generation.utils.global.element.GlobalElementResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.components.connection.HttpBasicAuthComponent;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.components.connection.WsdlProviderComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.EndpointType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PatternType;
import org.mule.devkit.model.studio.StudioModel;

public class MuleStudioEditorXmlGenerator
extends AbstractMuleStudioGenerator
implements MultiModuleGenerator {
    public static final String URI_PREFIX = "http://www.mulesoft.org/schema/mule/";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_CAPTION = "General";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION = "General";
    public static final String ADVANCED_ATTRIBUTE_CATEGORY_CAPTION = "Advanced";
    public static final String GROUP_DEFAULT_CAPTION = "Basic Settings";
    private ObjectFactory objectFactory = new ObjectFactory();
    private static final List<Product> PRODUCES = Arrays.asList(Product.STUDIO_EDITOR_XML);
    private static final String EDITOR_XML_FILE_NAME = "editors.xml";

    @Override
    public List<Product> consumes() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void generate(List<Module> modules) {
        List<Module> connectorOrModule = this.getSortedConnectorAndOauthModules(modules);
        for (Module module : connectorOrModule) {
            this.generateModule(module);
        }
    }

    private List<Module> getSortedConnectorAndOauthModules(List<Module> modules) {
        ArrayList<Module> connectorOrModule = new ArrayList<Module>(modules);
        Collections.sort(connectorOrModule, new ModuleComparator());
        return connectorOrModule;
    }

    private void executeOncePerNamespace(NamespaceType namespace, Module module) {
        String moduleName = module.getModuleName();
        namespace.setPrefix(moduleName);
        namespace.setUrl(URI_PREFIX + moduleName);
        this.ctx().getStudioModel().addPatternTypeOperation(moduleName, (StudioModel.BuilderWithArgs)new PatternTypeOperationsChooser(this.ctx(), module));
        if (this.needsGlobalCloudConnectorElement(module)) {
            GlobalType globalCloudConnector = new ParentCloudConnectorTypeBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
            if (module instanceof ManagedConnectionModule || !module.manager().connectionManagementComponents().isEmpty()) {
                if (this.hasStrategy(module, ConnectStrategy.SINGLE_INSTANCE)) {
                    NestedElementType cacheConfigNestedElementType = new CacheConfigNestedElementBuilder(this.ctx(), module).build();
                    namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNested(cacheConfigNestedElementType));
                }
                if (this.hasStrategy(module, ConnectStrategy.MULTIPLE_INSTANCES)) {
                    NestedElementType poolingProfileNestedElementType = new PoolingProfileNestedElementBuilder(this.ctx(), module).build();
                    namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNested(poolingProfileNestedElementType));
                }
                NestedElementType reconnectionNestedElement = new ReconnectionNestedElementBuilder(this.ctx(), module).build();
                namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNested(reconnectionNestedElement));
            }
        }
        this.processTransformerMethods(module, namespace);
        this.processSourceMethods(module, namespace);
    }

    private boolean hasStrategy(Module module, ConnectStrategy strategy) {
        if (module instanceof ManagedConnectionModule) {
            if (((ManagedConnectionModule)module).getConnectMethod().getStrategy().equals((Object)strategy)) {
                return true;
            }
        } else {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                if (!connectionManagementComponent.getConnectMethod().getStrategy().equals((Object)strategy)) continue;
                return true;
            }
        }
        return false;
    }

    private void generateModule(Module module) {
        String moduleName = module.getModuleName();
        boolean isOAuth = module instanceof OAuthModule || module.manager().oauth2Component().isPresent();
        Context ctx = this.ctx();
        StudioModel studioModel = ctx.getStudioModel();
        NamespaceType namespace = studioModel.getOrCreateNamespace(module.getModuleName());
        if (isOAuth) {
            studioModel.addIsOAuth(moduleName, isOAuth);
            studioModel.addNestedElements(moduleName, (StudioModel.Builder)new OAuthConfigNestedElementsBuilder(ctx, module));
        }
        if (module.hasProcessorMethodWithParameter(HttpCallback.class)) {
            studioModel.addNestedElements(moduleName, (StudioModel.Builder)new HttpCallbackNestedElementBuilder(ctx, module));
        }
        studioModel.addProcessorMethods(moduleName, (StudioModel.BuilderWithArgs)new ProcessorMethodsChooser(ctx, module, this.objectFactory));
        studioModel.addNestedElements(moduleName, (StudioModel.Builder)new NestedsBuilder(ctx, module));
        if (!moduleName.equals(namespace.getPrefix())) {
            this.executeOncePerNamespace(namespace, module);
        }
        if (this.needsGlobalCloudConnectorElement(module)) {
            StudioModel.ConfigRefBuilder simpleConfigRefBuilder = studioModel.getConfigBuilderRef(moduleName);
            if (studioModel.getConfigBuilderRef(moduleName) == null && this.needsGlobalCloudConnectorElement(module)) {
                simpleConfigRefBuilder = new SimpleConfigRefBuilder(this.ctx(), module);
                studioModel.addConfigBuilderRef(module.getModuleName(), simpleConfigRefBuilder);
            }
            this.generateGlobalCloudConnector(module, namespace, (StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>>)simpleConfigRefBuilder);
        }
        String editorFileName = EDITOR_XML_FILE_NAME;
        ModuleRelativePathBuilder editorXMLPath = new ModuleRelativePathBuilder(editorFileName);
        studioModel.addNamespaceType(moduleName, editorXMLPath.build(module).getFullPath());
        ctx.registerProduct(Product.STUDIO_EDITOR_XML, (Identifiable)module, (Object)editorXMLPath);
    }

    private boolean needsGlobalCloudConnectorElement(Module module) {
        return module.hasProcessors() || module.hasSources() || module.hasFilters() || !module.manager().wsdlProviderComponent().isEmpty();
    }

    private void generateGlobalCloudConnector(Module module, NamespaceType namespace, StudioModel.ConfigRefBuilder<JAXBElement<? extends AbstractElementType>> simpleConfigRefBuilder) {
        List<GlobalType> globalCloudConnectors = this.getGlobalTypes(module);
        for (GlobalType globalCloudConnector : globalCloudConnectors) {
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
            simpleConfigRefBuilder.addRequiredType(globalCloudConnector.getLocalId());
        }
    }

    private List<GlobalType> getGlobalTypes(final Module module) {
        return GlobalElementFactory.getGlobalElementBeanDefinitionGenerator((Module)module, (GlobalElementResolver)new AbstractGlobalElementResolver<GlobalType>(){

            public boolean supportsOAuth(Module module2) {
                return OAuth2StrategyUtilsResolver.hasOAuth2Component((Module)module2);
            }

            public boolean supportsConnectionManagement(Module module2) {
                return !module2.manager().connectionManagementComponents().isEmpty();
            }

            public GlobalType genericGlobalElement() {
                return new GlobalCloudConnectorModuleBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, false, "parentConfig").build();
            }

            public List<? extends GlobalType> connectionManagementGlobalElement() {
                ArrayList<GlobalType> globalCloudConnectors = new ArrayList<GlobalType>();
                for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                    globalCloudConnectors.add(new GlobalCloudConnectorConnectionManagementBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, connectionManagementComponent, false, "parentConfig").build());
                }
                return globalCloudConnectors;
            }

            public GlobalType oauthGlobalElement() {
                return new GlobalCloudConnectorOAuthBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, (OAuth2Component)module.manager().oauth2Component().get(), false, "parentConfig").build();
            }

            public GlobalType httpBasicAuthGlobalElement() {
                return new GlobalCloudConnectorHttpBasicAuthBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, (HttpBasicAuthComponent)module.manager().httpBasicAuthComponent().get(), false, "parentConfig").build();
            }

            public List<? extends GlobalType> basicGlobalElement() {
                ArrayList<GlobalType> globalCloudConnectors = new ArrayList<GlobalType>();
                for (ConfigurationComponent configurationComponent : module.manager().configurationComponents()) {
                    globalCloudConnectors.add(new GlobalCloudConnectorConfigurationBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, configurationComponent, false, "parentConfig").build());
                }
                return globalCloudConnectors;
            }

            public List<GlobalType> wsdlProviderGlobalElement() {
                ArrayList<GlobalType> globalCloudConnectors = new ArrayList<GlobalType>();
                for (WsdlProviderComponent wsdlProviderComponent : module.manager().wsdlProviderComponent()) {
                    globalCloudConnectors.add(new GlobalCloudConnectorWsdlProviderBuilder(MuleStudioEditorXmlGenerator.this.ctx(), module, wsdlProviderComponent, false, "parentConfig").build());
                }
                return globalCloudConnectors;
            }
        });
    }

    private void processTransformerMethods(Module module, NamespaceType namespace) {
        if (module.hasTransformers()) {
            namespace.getConnectorOrEndpointOrGlobal().add(new PatternTypeOperationsBuilder(this.ctx(), module, PatternTypes.TRANSFORMER).build());
            namespace.getConnectorOrEndpointOrGlobal().add(new AbstractTransformerBuilder(this.ctx(), module).build());
            GlobalType globalTransformer = new GlobalTransformerTypeOperationsBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
        for (Method transformerMethod : module.getTransformerMethods()) {
            PatternType transformer = new PatternTypeBuilder(this.ctx(), transformerMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeTransformer(transformer));
            GlobalType globalTransformer = new GlobalTransformerTypeBuilder(this.ctx(), transformerMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
    }

    private void processSourceMethods(Module module, NamespaceType namespace) {
        List sourceMethods = module.getSourceMethods();
        if (!sourceMethods.isEmpty()) {
            EndpointType endpointTypeListingOps = new EndpointTypeOperationsBuilder(this.ctx(), module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createCloudConnectorEndpoint(endpointTypeListingOps));
        }
        for (Method sourceMethod : sourceMethods) {
            EndpointType endpoint = new EndpointTypeBuilder(this.ctx(), sourceMethod, module).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createCloudConnectorEndpoint(endpoint));
        }
    }

    public static class ProcessorMethodsChooser
    implements StudioModel.BuilderWithArgs<Boolean, List<JAXBElement<? extends AbstractElementType>>> {
        private Module module;
        private ObjectFactory objectFactory;
        private Context ctx;

        public ProcessorMethodsChooser(Context ctx, Module module, ObjectFactory objectFactory) {
            this.module = module;
            this.ctx = ctx;
            this.objectFactory = objectFactory;
        }

        public List<JAXBElement<? extends AbstractElementType>> build(Boolean isOAuth) {
            ArrayList<JAXBElement<? extends AbstractElementType>> list = new ArrayList<JAXBElement<? extends AbstractElementType>>();
            for (ProcessorMethod processorMethod : this.module.getProcessorMethods()) {
                PatternType cloudConnector = new PatternTypeBuilder(this.ctx, (Method)processorMethod, this.module).build();
                if (processorMethod.hasInputOrOutputDynamicMetaData() || processorMethod.hasQuery() || processorMethod.hasStaticKeyMetaData() || processorMethod.hasMetaDataScope()) {
                    cloudConnector.setMetaData("dynamic");
                } else if (processorMethod.hasDynamicMetaData()) {
                    cloudConnector.setMetaData("static");
                }
                if (processorMethod.hasStaticKeyOutputMetaData()) {
                    cloudConnector.setMetaDataStaticKey(processorMethod.getStaticKeyOutputMetaData().type());
                }
                ArrayList<String> categories = new ArrayList<String>();
                ArrayList<DeclaredType> annotationValuesCategories = new ArrayList<DeclaredType>();
                if (processorMethod.hasMetaDataScope()) {
                    annotationValuesCategories.add(processorMethod.metaDataScope());
                } else if (this.module.getAnnotation(MetaDataScope.class) != null) {
                    annotationValuesCategories.add(this.module.metaDataScope());
                }
                for (DeclaredType declaredType : annotationValuesCategories) {
                    String fullQualifiedName = declaredType.toString();
                    categories.add(fullQualifiedName.substring(fullQualifiedName.lastIndexOf(".") + 1));
                }
                if (!categories.isEmpty()) {
                    cloudConnector.setCategories(StringUtils.join(categories, (String)","));
                }
                if (processorMethod.hasReturnGenericType(TransformingValue.class) && processorMethod.hasAnnotation(UserDefinedMetaData.class)) {
                    cloudConnector.setSupportsUserDefinedMetaData(true);
                }
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(cloudConnector));
            }
            if (isOAuth.booleanValue()) {
                PatternType authorize = new OAuthPatternTypeBuilder(this.ctx, "authorize", this.module).build();
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(authorize));
                PatternType unAuthorize = new OAuthPatternTypeBuilder(this.ctx, "unauthorize", this.module).build();
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(unAuthorize));
            }
            if (!this.module.manager().wsdlProviderComponent().isEmpty()) {
                PatternType invoke = new InvokeWsdlPatternTypeBuilder(this.ctx, this.module).build();
                list.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNamespaceTypeCloudConnector(invoke));
            }
            return list;
        }
    }

    public static class PatternTypeOperationsChooser
    implements StudioModel.BuilderWithArgs<Boolean, JAXBElement<PatternType>> {
        private Context ctx;
        private Module module;

        public PatternTypeOperationsChooser(Context ctx, Module module) {
            this.ctx = ctx;
            this.module = module;
        }

        public JAXBElement<PatternType> build(Boolean isOAuth) {
            if (isOAuth.booleanValue()) {
                return new OAuthPatternTypeOperationsBuilder(this.ctx, this.module, PatternTypes.CLOUD_CONNECTOR).build();
            }
            return new PatternTypeOperationsBuilder(this.ctx, this.module, PatternTypes.CLOUD_CONNECTOR).build();
        }
    }
}

