/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio.editor;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import javax.xml.bind.JAXBElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.api.annotations.Paged;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.QueryOperator;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.EnumElementComparator;
import org.mule.devkit.generation.studio.editor.MuleStudioUtils;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.components.connection.OAuth2Component;
import org.mule.devkit.model.module.components.metadatacategory.MetaDataCategoryComponent;
import org.mule.devkit.model.module.connectivity.ConnectionManagementCapability;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.ModeElementType;
import org.mule.devkit.model.studio.ModeType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.NewType;
import org.mule.devkit.model.studio.NoOperationType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.QueryType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.TextType;
import org.mule.devkit.model.studio.collection.CollectionAttributeType;
import org.mule.devkit.model.studio.collection.ListOfMapAttributeType;
import org.mule.devkit.model.studio.collection.ObjectListAttributeType;
import org.mule.devkit.model.studio.collection.StringListAttributeType;
import org.mule.devkit.model.studio.collection.StringMapAttributeType;
import org.mule.devkit.model.studio.metadata.MultiTypeChooserType;
import org.mule.devkit.model.studio.metadata.TypeChooserType;
import org.mule.devkit.utils.NameUtils;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.util.StringUtils;

public abstract class BaseStudioXmlBuilder {
    public static final String GENERAL_GROUP_NAME = "General";
    public static final String CONNECTION_GROUP_NAME = "Connection";
    public static final String ADVANCED_CONNECTION_GROUP_NAME = "Connector Configuration Overrides";
    private static final String QUERY_GROUP_NAME = "Query";
    private static final String PAGING_GROUP_NAME = "Paging";
    private static final String MESSAGE_SOURCE_POLLING_GROUP_NAME = "Polling";
    public static final String STUDIO_HTTP_REQUEST_CONFIG = "http://www.mulesoft.org/schema/mule/http/request-config";
    public static final String METADATA_KEY_LEVELS_CAPTION_SEPARATOR = ",";
    protected ObjectFactory objectFactory;
    protected MuleStudioUtils helper;
    protected Module module;
    protected Method method;
    protected String moduleName;
    protected Context context;

    protected BaseStudioXmlBuilder(Context context) {
        this.context = context;
        this.helper = new MuleStudioUtils();
        this.objectFactory = new ObjectFactory();
    }

    protected BaseStudioXmlBuilder(Context context, Module module) {
        this(context);
        this.module = module;
        this.moduleName = module.getModuleName();
    }

    protected Group createGroupWithModeSwitch(List<? extends Method> methods) {
        ModeType modeSwitch = this.getModeType(methods);
        return this.getModuleConnectorGenericGroup(modeSwitch);
    }

    protected Group createGroupWithNoOperationModeSwitchForProcessors(List<? extends Method> methods) {
        return this.createGroupWithNoOperationModeSwitch(methods, "processor");
    }

    protected Group createGroupWithNoOperationModeSwitchForSources(List<? extends Method> methods) {
        return this.createGroupWithNoOperationModeSwitch(methods, "source");
    }

    protected Group createGroupWithNoOperationModeSwitch(List<? extends Method> methods, String typeOfConnectorName) {
        ModeType modeSwitch = this.getModeType(methods);
        if (this.module.manager().wsdlProviderComponent().isEmpty()) {
            NoOperationType noOperation = new NoOperationType();
            noOperation.setAbstractElement("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getGlobalRefId(this.module.getModuleName()));
            noOperation.setVersions(this.buildVersionsString());
            noOperation.setConnectorName(typeOfConnectorName);
            modeSwitch.setNoOperation(noOperation);
        }
        return this.getModuleConnectorGenericGroup(modeSwitch);
    }

    private ModeType getModeType(List<? extends Method> methods) {
        ModeType modeSwitch = new ModeType();
        modeSwitch.getMode().addAll(this.getModes(methods));
        modeSwitch.setCaption(this.helper.formatCaption("Operation"));
        modeSwitch.setName(StringUtils.capitalize((String)this.moduleName) + " operations to execute");
        modeSwitch.setDescription(this.helper.formatDescription("Operation"));
        modeSwitch.setAlwaysCombo(Boolean.valueOf(true));
        return modeSwitch;
    }

    private Group getModuleConnectorGenericGroup(ModeType modeSwitch) {
        Group group = new Group();
        group.setId(this.module.getModuleName() + "ConnectorGeneric");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupModeSwitch(modeSwitch));
        group.setCaption(this.helper.formatCaption("Basic Settings"));
        return group;
    }

    protected List<ModeElementType> getModes(List<? extends Method> methods) {
        ArrayList<ModeElementType> modes = new ArrayList<ModeElementType>();
        if (!this.module.manager().wsdlProviderComponent().isEmpty()) {
            ModeElementType mode = new ModeElementType();
            String methodName = "invoke";
            mode.setModeId("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + methodName);
            mode.setModeLabel(StringUtils.capitalize((String)methodName));
            modes.add(0, mode);
        }
        for (Method method : this.removeContainer(methods)) {
            ModeElementType mode = new ModeElementType();
            mode.setModeId("http://www.mulesoft.org/schema/mule/" + this.module.getModuleName() + '/' + this.helper.getLocalId(method));
            mode.setModeLabel(StringUtils.capitalize((String)this.helper.getFriendlyName(method)));
            modes.add(mode);
        }
        return modes;
    }

    private List<Method> removeContainer(List<? extends Method> methods) {
        ArrayList<Method> methodsWithoutContainer = new ArrayList<Method>(methods);
        CollectionUtils.filter(methodsWithoutContainer, (Predicate)new NotPredicate((Predicate)new IsContainerMethod()));
        return methodsWithoutContainer;
    }

    protected BaseStudioXmlBuilder(Context context, Method method, Module module) {
        this(context, module);
        this.method = method;
    }

    protected List<AttributeCategory> processMethodParameters() {
        Map<String, AttributeCategory> attributeCategoriesByName = this.processVariableElements(this.getParametersSorted());
        if (this.method instanceof ProcessorMethod) {
            ProcessorMethod processor = (ProcessorMethod)this.method;
            if (this.shouldAddAccessTokenId(processor)) {
                this.processOAuthProtectedMethod(attributeCategoriesByName);
            }
            if (processor.isPaged()) {
                this.processPagedMethod(attributeCategoriesByName, processor);
            }
        }
        if (this.method instanceof SourceMethod && ((SourceMethod)this.method).isPolling()) {
            this.processPoolingSourceMethod(attributeCategoriesByName, (SourceMethod)this.method);
        }
        return new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
    }

    private void processPagedMethod(Map<String, AttributeCategory> attributeCategoriesByName, ProcessorMethod processor) {
        Paged cfg = processor.getPagingAnnotation();
        StringAttributeType fetchSize = new StringAttributeType();
        fetchSize.setName("fetchSize");
        fetchSize.setRequired(Boolean.valueOf(false));
        fetchSize.setDefaultValue(String.valueOf(cfg.defaultFetchSize()));
        fetchSize.setCaption(this.helper.formatCaption("Fetch Size"));
        fetchSize.setDescription(this.helper.formatDescription("The amount of items to fetch on each invocation to the data source"));
        fetchSize.setJavaType("java.lang.String");
        AttributeCategory attributeCategory = this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        Group group = new Group();
        group.setCaption(this.helper.formatCaption(PAGING_GROUP_NAME));
        group.setId(StringUtils.uncapitalize((String)PAGING_GROUP_NAME));
        group.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)fetchSize));
        attributeCategory.getGroup().add(group);
    }

    private void processPoolingSourceMethod(Map<String, AttributeCategory> attributeCategoriesByName, SourceMethod sourceMethod) {
        StringAttributeType pollingPeriod = new StringAttributeType();
        pollingPeriod.setName("pollingPeriod");
        pollingPeriod.setRequired(Boolean.valueOf(false));
        pollingPeriod.setDefaultValue(String.valueOf(sourceMethod.getPollingPeriod()));
        pollingPeriod.setCaption(this.helper.formatCaption("Polling Period"));
        pollingPeriod.setDescription(this.helper.formatDescription("Polling Period for Message Sources with Polling Strategy in ms"));
        pollingPeriod.setJavaType("java.lang.String");
        AttributeCategory attributeCategory = this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        Group group = new Group();
        group.setCaption(this.helper.formatCaption(MESSAGE_SOURCE_POLLING_GROUP_NAME));
        group.setId(StringUtils.uncapitalize((String)MESSAGE_SOURCE_POLLING_GROUP_NAME));
        group.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)pollingPeriod));
        attributeCategory.getGroup().add(group);
    }

    private Group getOrCreateGroup(Map<String, AttributeCategory> attributeCategoriesByName, String name) {
        AttributeCategory attributeCategory = null;
        if (attributeCategoriesByName.get(name) != null) {
            attributeCategory = attributeCategoriesByName.get(name);
        } else {
            attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.formatCaption(name));
            attributeCategory.setDescription(name);
            attributeCategoriesByName.put(name, attributeCategory);
        }
        Group group = this.getGroup(attributeCategory, name);
        if (group == null) {
            group = new Group();
            group.setCaption(this.helper.formatCaption(name));
            group.setId(StringUtils.uncapitalize((String)name));
            attributeCategory.getGroup().add(group);
        }
        return group;
    }

    private boolean shouldAddAccessTokenId(ProcessorMethod processor) {
        return processor.isOAuthProtected() && (this.module.manager().oauth2Component().isPresent() && ((OAuth2Component)this.module.manager().oauth2Component().get()).getOAuthVersion().equals((Object)OAuthVersion.V2) || processor.canBeUsedInOAuthManagement() && processor.getOAuthModule().getOAuthVersion().equals((Object)OAuthVersion.V2));
    }

    private void processOAuthProtectedMethod(Map<String, AttributeCategory> attributeCategoriesByName) {
        StringAttributeType accessTokenId = new StringAttributeType();
        accessTokenId.setName("accessTokenId");
        accessTokenId.setRequired(Boolean.valueOf(false));
        accessTokenId.setCaption(this.helper.formatCaption("Access Token Id"));
        accessTokenId.setDescription(this.helper.formatDescription("The id of the access token that will be used to authenticate the call"));
        accessTokenId.setJavaType("java.lang.String");
        Group group = this.getOrCreateGroup(attributeCategoriesByName, "Advanced");
        group.getRegexpOrEncodingOrModeSwitch().add(this.helper.createJAXBElement((AttributeType)accessTokenId));
    }

    private Group getGroup(AttributeCategory attributeCategory, String groupName) {
        if (attributeCategory != null) {
            for (Group group : attributeCategory.getGroup()) {
                if (!StringUtils.uncapitalize((String)groupName).equalsIgnoreCase(group.getId())) continue;
                return group;
            }
        }
        return null;
    }

    protected Map<String, AttributeCategory> processVariableElements(List<? extends Variable> variableElements) {
        LinkedHashMap<String, Group> groupsByName = new LinkedHashMap<String, Group>();
        LinkedHashMap<String, AttributeCategory> attributeCategoriesByName = new LinkedHashMap<String, AttributeCategory>();
        this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        this.processConnectionAttributes(groupsByName, attributeCategoriesByName);
        if (this.hasStrategy(this.module, ConnectStrategy.SINGLE_INSTANCE)) {
            this.createCacheConfigAttributes(groupsByName, attributeCategoriesByName);
        }
        if (this.hasStrategy(this.module, ConnectStrategy.MULTIPLE_INSTANCES)) {
            this.createPoolingProfileAttributes(groupsByName, attributeCategoriesByName);
        }
        this.createReconnectionAttributes(groupsByName, attributeCategoriesByName);
        this.createOAuthConfig(groupsByName, attributeCategoriesByName);
        this.createHttpCallbackConfig(groupsByName, attributeCategoriesByName);
        this.createMetaDataAttributes(groupsByName, attributeCategoriesByName);
        for (Variable variable : variableElements) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement(variable);
            AttributeCategory attributeCategory = this.getOrCreateAttributeCategory(attributeCategoriesByName, (Placement)variable.getAnnotation(Placement.class));
            Group group = this.getOrCreateGroup(groupsByName, variable);
            group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            if (attributeCategory.getGroup().contains(group)) continue;
            attributeCategory.getGroup().add(group);
        }
        return attributeCategoriesByName;
    }

    private boolean hasStrategy(Module module, ConnectStrategy strategy) {
        if (module instanceof ManagedConnectionModule) {
            if (((ManagedConnectionModule)module).getConnectMethod().getStrategy().equals((Object)strategy)) {
                return true;
            }
        } else {
            for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
                if (!connectionManagementComponent.getConnectMethod().getStrategy().equals((Object)strategy)) continue;
                return true;
            }
        }
        return false;
    }

    protected void createMetaDataAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createReconnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createPoolingProfileAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createCacheConfigAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createOAuthConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    protected void createHttpCallbackConfig(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    private AttributeCategory getOrCreateDefaultAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName) {
        return this.getOrCreateAttributeCategory(attributeCategoriesByName, null);
    }

    private AttributeCategory getOrCreateAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName, Placement placement) {
        if (placement == null || StringUtils.isBlank((String)placement.tab())) {
            if (!attributeCategoriesByName.containsKey(GENERAL_GROUP_NAME)) {
                AttributeCategory attributeCategoryGeneral = new AttributeCategory();
                attributeCategoryGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                attributeCategoryGeneral.setDescription(this.helper.formatDescription(GENERAL_GROUP_NAME));
                attributeCategoriesByName.put(GENERAL_GROUP_NAME, attributeCategoryGeneral);
            }
            return attributeCategoriesByName.get(GENERAL_GROUP_NAME);
        }
        String attributeCategoryName = StringUtils.isNotBlank((String)placement.tab()) ? placement.tab() : GENERAL_GROUP_NAME;
        if (!attributeCategoriesByName.containsKey(attributeCategoryName)) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.formatCaption(attributeCategoryName));
            attributeCategory.setDescription(this.helper.formatDescription(attributeCategoryName));
            attributeCategoriesByName.put(attributeCategoryName, attributeCategory);
        }
        return attributeCategoriesByName.get(attributeCategoryName);
    }

    private Group getOrCreateGroup(Map<String, Group> groupsByName, Variable parameter) {
        Placement placement;
        Placement placement2 = placement = parameter != null ? (Placement)parameter.getAnnotation(Placement.class) : null;
        if (parameter != null && parameter.isQuery()) {
            Group queryGroup = new Group();
            queryGroup.setCaption(this.helper.formatCaption(QUERY_GROUP_NAME));
            queryGroup.setId(StringUtils.uncapitalize((String)QUERY_GROUP_NAME));
            groupsByName.put(QUERY_GROUP_NAME, queryGroup);
            return groupsByName.get(QUERY_GROUP_NAME);
        }
        if (placement == null || StringUtils.isBlank((String)placement.group())) {
            if (!groupsByName.containsKey(GENERAL_GROUP_NAME)) {
                Group groupGeneral = new Group();
                groupGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                groupGeneral.setId(StringUtils.uncapitalize((String)GENERAL_GROUP_NAME));
                groupsByName.put(GENERAL_GROUP_NAME, groupGeneral);
            }
            return groupsByName.get(GENERAL_GROUP_NAME);
        }
        String groupName = placement.group();
        if (!groupsByName.containsKey(groupName)) {
            Group group = new Group();
            group.setCaption(groupName);
            group.setId(StringUtils.uncapitalize((String)groupName));
            groupsByName.put(groupName, group);
        }
        return groupsByName.get(groupName);
    }

    protected boolean isConfigurableVariable(Variable<?> variable) {
        if (this.module != null && this.module.getConfigurableFields() != null) {
            return this.module.getConfigurableFields().contains(variable);
        }
        return false;
    }

    protected JAXBElement<? extends AttributeType> createJaxbElement(Variable<?> variable) {
        if (variable.asType().isComplexType() && !variable.isRefOnly()) {
            NestedElementReference complexTypeNestedElementReference = this.createNestedElementReference(variable);
            return this.objectFactory.createGroupChildElement(complexTypeNestedElementReference);
        }
        if (variable.asType().inheritsFrom(HttpRequesterConfig.class)) {
            NewType globalRef = this.createHttpRequesterConfigGlobalRef(variable);
            return this.objectFactory.createGroupGlobalRef(globalRef);
        }
        return this.helper.createJAXBElement(this.createAttributeTypeFromVariable(variable));
    }

    protected AttributeType createAttributeTypeFromVariable(Variable<?> variable) {
        Object attributeType = variable.isQuery() ? this.createQueryType(variable) : (variable.isMetaDataKey() ? this.createTypeChooserType(variable) : (variable.asType().isEnum() ? this.createEnumType(variable) : (variable.isText() ? this.createTextType(variable) : (this.isComplexList(variable) ? this.createComplexListType(variable) : (this.helper.isCollection(variable) && !variable.isRefOnly() ? this.handleCollectionVariable(variable) : this.createAttributeType(variable))))));
        if (this.isConfigurableVariable(variable)) {
            this.setMetadataAttributes(variable, (AttributeType)attributeType);
        }
        return attributeType;
    }

    protected void setMetadataAttributes(Variable<?> variable, AttributeType attributeType) {
    }

    protected AttributeType createTextType(Variable<?> variable) {
        TextType text = new TextType();
        text.setName(variable.getName());
        text.setCaption(NameUtils.friendlyNameFromCamelCase((String)variable.getName()));
        text.setRequired(Boolean.valueOf(!variable.isOptional()));
        text.setIsToElement(Boolean.valueOf(true));
        text.setWrapWithCDATA(Boolean.valueOf(true));
        text.setVisibleInDialog(Boolean.valueOf(true));
        return text;
    }

    protected AttributeType createQueryType(Variable<?> variable) {
        QueryType type = new QueryType();
        type.setSupportsExpressions(Boolean.valueOf(true));
        type.setAssociatedConfig("config-ref");
        Query qVariable = (Query)variable.getAnnotation(Query.class);
        List<QueryOperator> disabledOperators = Arrays.asList(qVariable.disabledOperators());
        type.setAndOperator(disabledOperators.contains(QueryOperator.AND) ? "disabled" : "enabled");
        type.setOrOperator(disabledOperators.contains(QueryOperator.OR) ? "disabled" : "enabled");
        type.setNativeQuery(this.module.hasQueryTranslator() ? "enabled" : "disabled");
        type.setLimit(qVariable.limit() ? "enabled" : "disabled");
        type.setOffset(qVariable.offset() ? "enabled" : "disabled");
        type.setOrderBy(qVariable.orderBy() ? "enabled" : "disabled");
        this.helper.setAttributeTypeInfo(variable, (AttributeType)type);
        return type;
    }

    protected AttributeType createComplexListType(Variable parameter) {
        ObjectListAttributeType objectListAttributeTyper = new ObjectListAttributeType();
        objectListAttributeTyper.setListName(NameUtils.uncamel((String)parameter.getName()));
        this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)objectListAttributeTyper);
        return objectListAttributeTyper;
    }

    private boolean isComplexList(Variable parameter) {
        return parameter.asType().isArrayOrList() && !parameter.getTypeArguments().isEmpty() && ((Type)parameter.getTypeArguments().get(0)).asTypeMirror().getKind().equals((Object)TypeKind.DECLARED) && ((Type)parameter.getTypeArguments().get(0)).isComplexTypeWithGetterAndSetter(false);
    }

    private AttributeType createTypeChooserType(Variable<?> variable) {
        MetaDataKeyParam metaDataKeyParam = (MetaDataKeyParam)variable.getAnnotation(MetaDataKeyParam.class);
        Optional<ProcessorMethod> processorMethod = this.helper.getProcessorMethod(this.module, this.method);
        Optional metaDataCategory = processorMethod.isPresent() ? ((ProcessorMethod)processorMethod.get()).getMetaDataCategoryComponent() : Optional.absent();
        Object type = metaDataCategory.isPresent() && ((MetaDataCategoryComponent)metaDataCategory.get()).isMultiLevelCategory() ? this.createMultiTypeChooserType((Optional<MetaDataCategoryComponent>)metaDataCategory, metaDataKeyParam) : this.createSingleTypeChooserType(metaDataKeyParam);
        this.helper.setAttributeTypeInfo(variable, (AttributeType)type);
        return type;
    }

    private TypeChooserType createSingleTypeChooserType(MetaDataKeyParam metaDataKeyParam) {
        TypeChooserType type = new TypeChooserType();
        type.setSupportsExpressions(Boolean.valueOf(true));
        type.setAssociatedConfig("config-ref");
        type.setAffects(metaDataKeyParam.affects().toString());
        return type;
    }

    private MultiTypeChooserType createMultiTypeChooserType(Optional<MetaDataCategoryComponent> metaDataCategory, MetaDataKeyParam metaDataKeyParam) {
        String keySeparator = ((MetaDataCategoryComponent)metaDataCategory.get()).getMetaDataKeySeparator();
        MultiTypeChooserType type = new MultiTypeChooserType();
        type.setCaptions(StringUtils.join((Object[])metaDataKeyParam.labels(), (String)METADATA_KEY_LEVELS_CAPTION_SEPARATOR));
        type.setKeySeparator(keySeparator);
        type.setSupportsExpressions(Boolean.valueOf(true));
        type.setAssociatedConfig("config-ref");
        type.setAffects(metaDataKeyParam.affects().toString());
        return type;
    }

    private NestedElementReference createNestedElementReference(Variable parameter) {
        NestedElementReference childElement = new NestedElementReference();
        String defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            childElement.setDefaultValue(defaultValue);
        }
        childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + NameUtils.uncamel((String)parameter.getName()));
        childElement.setCaption(this.helper.getFormattedCaption(parameter));
        childElement.setAllowMultiple(Boolean.valueOf(false));
        childElement.setInplace(Boolean.valueOf(true));
        childElement.setJavaType(parameter.getJavaType());
        childElement.setRequired(Boolean.valueOf(!parameter.isOptional()));
        return childElement;
    }

    private NewType createHttpRequesterConfigGlobalRef(Variable<?> variable) {
        NewType globalRef = new NewType();
        globalRef.setRequiredType(STUDIO_HTTP_REQUEST_CONFIG);
        globalRef.setName(variable.getName() + "-ref");
        globalRef.setCaption(this.helper.getFormattedCaption(variable));
        globalRef.setDescription(this.helper.formatDescription(variable.getJavaDocSummary()));
        globalRef.setRequired(Boolean.valueOf(!variable.isOptional()));
        return globalRef;
    }

    protected AttributeType handleCollectionVariable(Variable parameter) {
        StringListAttributeType attributeType;
        if (this.helper.isListOfMaps(parameter)) {
            ListOfMapAttributeType objectListAttributeType = new ListOfMapAttributeType();
            objectListAttributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
            objectListAttributeType.setListName(NameUtils.uncamel((String)parameter.getName()));
            objectListAttributeType.setInnerName(NameUtils.uncamel((String)("inner-" + NameUtils.singularize((String)parameter.getName()))));
            if (parameter.isMetaDataStaticKey()) {
                objectListAttributeType.setMetaDataStaticKey(((MetaDataStaticKey)parameter.getAnnotation(MetaDataStaticKey.class)).type());
            }
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)objectListAttributeType);
            attributeType = objectListAttributeType;
        } else if (this.helper.isSimpleList(parameter) || this.helper.isSimpleSet(parameter)) {
            StringListAttributeType stringListAttributeType = new StringListAttributeType();
            stringListAttributeType.setListName(NameUtils.uncamel((String)parameter.getName()));
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringListAttributeType);
            attributeType = stringListAttributeType;
        } else {
            StringMapAttributeType stringMapAttributeType = new StringMapAttributeType();
            stringMapAttributeType.setMapName(NameUtils.uncamel((String)parameter.getName()));
            if (parameter.isMetaDataStaticKey()) {
                stringMapAttributeType.setMetaDataStaticKey(((MetaDataStaticKey)parameter.getAnnotation(MetaDataStaticKey.class)).type());
            }
            this.setCommonCollectionAttributes(parameter, (CollectionAttributeType)stringMapAttributeType);
            attributeType = stringMapAttributeType;
        }
        attributeType.setRequired(Boolean.valueOf(!parameter.isOptional()));
        return attributeType;
    }

    protected void setCommonCollectionAttributes(Variable parameter, CollectionAttributeType collectionAttributeType) {
        collectionAttributeType.setItemName(NameUtils.uncamel((String)NameUtils.singularize((String)parameter.getName())));
        collectionAttributeType.setLocalName(this.helper.getLocalId(this.method, parameter));
        collectionAttributeType.setCaption(this.helper.getFormattedCaption(parameter));
        collectionAttributeType.setJavaType(parameter.getJavaType());
        String defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            collectionAttributeType.setDefaultValue(defaultValue);
        }
        if (this.method != null) {
            collectionAttributeType.setDescription(this.helper.formatDescription(this.method.getJavaDocParameterSummary(parameter.getName())));
        } else {
            collectionAttributeType.setDescription(this.helper.formatDescription(parameter.getJavaDocSummary()));
        }
    }

    private List<Parameter> getParametersSorted() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.method.getParameters());
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            if (!((Parameter)iterator.next()).shouldBeUIIgnored()) continue;
            iterator.remove();
        }
        Collections.sort(parameters, new VariableComparator());
        return parameters;
    }

    private AttributeType createAttributeType(Variable parameter) {
        AttributeType attributeType = this.helper.createAttributeTypeIgnoreEnumsAndCollections(parameter);
        if (attributeType != null) {
            this.helper.setAttributeTypeInfo(parameter, attributeType);
        }
        return attributeType;
    }

    protected List<AttributeType> getConnectionAttributes(ConnectionManagementCapability connectionManagementCapability) {
        ArrayList<AttributeType> parameters = new ArrayList<AttributeType>();
        for (Parameter connectParameter : connectionManagementCapability.getConnectMethod().getParameters()) {
            parameters.add(this.getAttributeType((Variable)connectParameter));
        }
        return parameters;
    }

    protected AttributeType getAttributeType(Variable variable) {
        AttributeType parameter = this.helper.createAttributeTypeIgnoreEnumsAndCollections(variable);
        this.helper.setAttributeTypeInfo(variable, parameter);
        parameter.setRequired(Boolean.valueOf(false));
        this.setMetadataAttributes(variable, parameter);
        return parameter;
    }

    private EnumType createEnumType(Variable<?> variable) {
        EnumType enumType = new EnumType();
        enumType.setSupportsExpressions(Boolean.valueOf(true));
        enumType.setAllowsCustom(Boolean.valueOf(true));
        this.helper.setAttributeTypeInfo(variable, (AttributeType)enumType);
        for (Identifiable enumMember : ((org.mule.devkit.model.EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            EnumElement enumElement = new EnumElement();
            enumElement.setValue(enumConstant);
            enumType.getOption().add(enumElement);
        }
        Collections.sort(enumType.getOption(), new EnumElementComparator());
        return enumType;
    }

    protected String buildVersionsString() {
        return "[" + this.module.getMinMuleVersion().toCompleteNumericVersion() + ",8.0.0]";
    }

    private class IsContainerMethod
    implements Predicate {
        private IsContainerMethod() {
        }

        public boolean evaluate(Object o) {
            ProcessorMethod processorMethod;
            return o instanceof ProcessorMethod && ((processorMethod = (ProcessorMethod)o).isContainer() || processorMethod.isContainerList());
        }
    }
}

