/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.studio.AbstractMuleStudioNamespaceGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.generation.studio.utils.MuleStudioPathResolver;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.util.IOUtils;

public class MuleStudioIconsGenerator
extends AbstractMuleStudioNamespaceGenerator {
    private static List<Product> PRODUCES = Arrays.asList(Product.STUDIO_ICONS);
    private ArrayList<ModuleRelativePathBuilder> iconsFileName;
    private static final String ICONS_SMALL = "icons/small";
    private static final String ICONS_LARGE = "icons/large";

    @Override
    public List<Product> produces() {
        return PRODUCES;
    }

    @Override
    public void generate(Module module) throws GenerationException {
        this.iconsFileName = new ArrayList();
        this.createCloudConnectorIcon(module);
        if (module.hasTransformers()) {
            this.createTransformerIcon(module);
        }
        if (module.hasSources()) {
            this.createSourceIcon(module);
        }
        if (this.hasContainer(module)) {
            this.createContainerIcon(module);
        }
        if (this.hasContainerList(module)) {
            this.createFlowIcon(module);
        }
        this.ctx().registerProduct(Product.STUDIO_ICONS, (Identifiable)module, this.iconsFileName);
    }

    private boolean hasContainer(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainer()) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainerList(Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.isContainerList()) continue;
            return true;
        }
        return false;
    }

    private void createSourceIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/%s-endpoint-24x16.png", module.getModuleName()), ICONS_SMALL, module, "%s-endpoint-24x16.png");
        this.copyFile(String.format("../../../icons/%s-endpoint-48x32.png", module.getModuleName()), ICONS_LARGE, module, "%s-endpoint-48x32.png");
    }

    private void createTransformerIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/%s-transformer-24x16.png", module.getModuleName()), ICONS_SMALL, module, "%s-transformer-24x16.png");
        this.copyFile(String.format("../../../icons/%s-transformer-48x32.png", module.getModuleName()), ICONS_LARGE, module, "%s-transformer-48x32.png");
    }

    private void createCloudConnectorIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/%s-connector-24x16.png", module.getModuleName()), ICONS_SMALL, module, "%s-connector-24x16.png");
        this.copyFile(String.format("../../../icons/%s-connector-48x32.png", module.getModuleName()), ICONS_LARGE, module, "%s-connector-48x32.png");
    }

    private void createContainerIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/%s-container-24x16.png", module.getModuleName()), ICONS_SMALL, module, "%s-container-24x16.png");
        this.copyFile(String.format("../../../icons/%s-container-48x32.png", module.getModuleName()), ICONS_LARGE, module, "%s-container-48x32.png");
    }

    private void createFlowIcon(Module module) throws GenerationException {
        this.copyFile(String.format("../../../icons/%s-flow-24x16.png", module.getModuleName()), ICONS_SMALL, module, "%s-flow-24x16.png");
        this.copyFile(String.format("../../../icons/%s-flow-48x32.png", module.getModuleName()), ICONS_LARGE, module, "%s-flow-48x32.png");
    }

    private void copyFile(String fileName, String folder, Module module, String sufix) throws GenerationException {
        InputStream iconStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = this.createFile(module, folder, fileName);
            File fileToCopy = MuleStudioPathResolver.getFileResolvingPackages(module, fileName);
            if (fileToCopy.exists()) {
                iconStream = new FileInputStream(fileToCopy);
            } else {
                String fileIconPath = String.format(sufix, "generic");
                iconStream = MuleStudioIconsGenerator.class.getClassLoader().getResourceAsStream(fileIconPath);
            }
            IOUtils.copy((InputStream)iconStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Error copying icons to output folder: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(iconStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)iconStream);
    }

    private OutputStream createFile(Module module, String folder, String fileName) throws GenerationException {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        try {
            ModuleRelativePathBuilder pathBuilder = new ModuleRelativePathBuilder(folder + "/" + fileName);
            String fullIconPath = pathBuilder.build(module).getFullPath();
            this.iconsFileName.add(pathBuilder);
            return this.ctx().getCodeModel().getCodeWriter().openBinary(null, fullIconPath);
        }
        catch (IOException e) {
            throw new GenerationException("Could not create file or folder " + fileName + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

