/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.studio.editor.globalcloudconnector;

import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.studio.editor.VariableComparator;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.GlobalType;

import java.util.Collections;
import java.util.List;

public class GlobalCloudConnectorConfigurationBuilder extends GlobalCloudConnectorTypeBuilder {

    private ConfigurationComponent configurationComponent;

    public GlobalCloudConnectorConfigurationBuilder(Context context, Module module, ConfigurationComponent configurationComponent, boolean abstrac7, String globalRefId) {
        super(context, module, abstrac7, globalRefId);
        this.configurationComponent = configurationComponent;
    }

    @Override
    protected void buildConnectivityTestingAttr(GlobalType globalCloudConnector) {
        setConnectivityTestingAttribute(globalCloudConnector, configurationComponent.testConnectivityMethod());
    }

    @Override
    protected List<Field> getConfigurableFieldsSorted() {
        List<Field> configurableFields = module.getConfigurableFields();
        configurableFields.addAll(configurationComponent.getConfigurableFields());
        Collections.sort(configurableFields, new VariableComparator());
        return configurableFields;
    }

    @Override
    protected boolean hasConnectionMethod() {
        return false;
    }

    @Override
    protected ConnectMethod connectMethod() {
        return null;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        String javaDocSummary = "Global " + configurationComponent.friendlyName() + " configuration information.";
        javaDocSummary += configurationComponent.getJavaDocSummary() != null ? " " + configurationComponent.getJavaDocSummary() : "";
        return helper.formatDescription(javaDocSummary);
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return configurationComponent.configElementName();
    }

    @Override
    protected String getCaptionBasedOnType() {
        return helper.getFormattedCaption(module).concat(": ").concat(configurationComponent.friendlyName());
    }

    @Override
    protected List<AttributeType> getConnectionAttributes() {
        return Collections.EMPTY_LIST;
    }
}
