/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.studio;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.apidoc.VelocityUtils;
import org.mule.devkit.generation.studio.AbstractMuleStudioGenerator;
import org.mule.devkit.generation.studio.packaging.ModuleRelativePathBuilder;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.apidoc.Element;
import org.mule.devkit.model.apidoc.ModuleModel;
import org.mule.devkit.model.code.writer.FilerCodeWriter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.utils.NameUtils;

public class MuleStudioContextualHelpGenerator
extends AbstractMuleStudioGenerator
implements ModuleGenerator {
    private final List<Product> CONSUMES = Arrays.asList(Product.APIDOC_MODEL);
    private Module module;
    private List<ModuleRelativePathBuilder> pathBuilders = new ArrayList<ModuleRelativePathBuilder>();
    private final String DOC = "doc";

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) throws GenerationException {
        this.module = module;
        VelocityEngine engine = VelocityUtils.getVelocityEngine();
        try {
            this.generateIndex(engine);
            this.generateElements(engine, this.getApidocModel().configs(), "doc/config");
            this.generateElements(engine, this.getApidocModel().processors(), "doc/processor");
            this.generateElements(engine, this.getApidocModel().transformers(), "doc/transformer");
            this.generateElements(engine, this.getApidocModel().filters(), "doc/filter");
            this.generateElements(engine, this.getApidocModel().sources(), "doc/source");
            this.ctx().registerProduct(Product.STUDIO_CONTEXTUAL_HELP, (Identifiable)module, this.pathBuilders);
        }
        catch (IOException e) {
            throw new GenerationException("Error while generating Contextual Help files: " + e.getMessage(), (Throwable)e);
        }
    }

    private void generateIndex(VelocityEngine engine) throws IOException {
        Template indexTemplate = engine.getTemplate("studio-ch-index.vm");
        VelocityContext indexContext = VelocityUtils.getContextBuilder().put(this.defaultContextProperties()).put("element", (Object)this.getApidocModel()).build();
        this.generateElement(indexTemplate, indexContext, this.generateFullPath("doc", "index"));
    }

    @Override
    public List<Product> consumes() {
        return this.CONSUMES;
    }

    private void generateElements(VelocityEngine engine, List<? extends Element> elements, String folderName) throws IOException {
        Template elementIndexTemplate = engine.getTemplate("studio-ch-element-index.vm");
        Template elementTemplate = engine.getTemplate("studio-ch-element.vm");
        for (Element element : elements) {
            VelocityContext context = VelocityUtils.getContextBuilder().put(this.defaultContextProperties()).put("element", (Object)element).build();
            this.generateElement(elementTemplate, context, this.generateFullPath(folderName, element.xsdName()));
        }
        if (!elements.isEmpty()) {
            VelocityContext context = VelocityUtils.getContextBuilder().put(this.defaultContextProperties()).put("elements", elements).put("kind", (Object)Paths.get(folderName, new String[0]).getFileName().toString()).build();
            this.generateElement(elementIndexTemplate, context, this.generateFullPath(folderName, "index"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateElement(Template template, VelocityContext context, String fullPath) throws IOException {
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        try (OutputStream os = null;){
            os = new FilerCodeWriter(this.ctx().getFiler()).openBinary(null, fullPath);
            os.write(writer.toString().getBytes());
        }
    }

    private String generateFullPath(String folderName, String fileName) {
        fileName = !StringUtils.isBlank((String)fileName) ? fileName + ".html" : fileName;
        ModuleRelativePathBuilder pathBuilder = new ModuleRelativePathBuilder(Paths.get(folderName, fileName).toString());
        this.pathBuilders.add(pathBuilder);
        return pathBuilder.build(this.module).getFullPath();
    }

    private ModuleModel getApidocModel() {
        return this.ctx().getApidocModel();
    }

    private Map<String, Object> defaultContextProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("docUrl", this.repoDocUrl());
        props.put("connectorVersion", this.ctx().getMavenInformation().getVersion());
        props.put("connectorName", this.ctx().getMavenInformation().getName());
        props.put("NameUtils", NameUtils.class);
        props.put("StringUtils", StringUtils.class);
        return props;
    }

    private String repoDocUrl() {
        String path;
        try {
            path = new URL(this.ctx().getMavenInformation().getUrl()).getPath();
        }
        catch (MalformedURLException e) {
            return "";
        }
        Optional owner = Optional.absent();
        Optional name = Optional.absent();
        for (String segment : path.split("/")) {
            if (segment.length() <= 0) continue;
            if (!owner.isPresent()) {
                owner = Optional.fromNullable((Object)segment);
                continue;
            }
            if (name.isPresent()) break;
            name = Optional.fromNullable((Object)segment);
        }
        return ((String)name.get()).equals("mule-devkit-parent") ? "" : String.format("http://%s.github.io/%s", owner.get(), name.get());
    }
}

